/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.cli;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ws.WebSocket;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.NoThrowAutoCloseable;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.RemoteValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.security.OnDiscKeyStore;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.jersey.JerseyClientFactory;
import io.bdeploy.jersey.cli.LocalLoginManager;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.ws.rs.core.UriBuilder;

public abstract class RemoteServiceTool<T extends Annotation>
extends ToolBase.ConfiguredCliTool<T> {
    public RemoteServiceTool(Class<T> configClass) {
        super(configClass);
    }

    @Override
    protected Collection<Class<? extends Annotation>> getConfigsForHelp() {
        ArrayList<Class<? extends Annotation>> help = new ArrayList<Class<? extends Annotation>>();
        help.add(RemoteConfig.class);
        help.addAll(super.getConfigsForHelp());
        return help;
    }

    private boolean isOptional() {
        try {
            Method method = this.getClass().getDeclaredMethod("run", this.getPrimaryConfigClass(), RemoteService.class);
            return method.getParameters()[1].getAnnotation(RemoteOptional.class) != null;
        }
        catch (NoSuchMethodException e) {
            this.out().println("WARN: cannot determine whether remote is optional: " + e.toString());
            return false;
        }
    }

    @Override
    protected final void run(T config) {
        RemoteConfig rc = this.getConfig(RemoteConfig.class);
        boolean optional = this.isOptional();
        boolean isTestMode = ToolBase.istTestModeLLM();
        LocalLoginManager llm = new LocalLoginManager();
        if (!optional && !isTestMode && llm.getCurrent() == null && rc.useLogin() == null) {
            this.helpAndFailIfMissing(rc.remote(), "Missing --remote, --useLogin, or current login using `bdeploy login`");
        }
        RemoteService svc = null;
        if (rc.remote() != null) {
            svc = this.createServiceFromCli(rc, optional);
        } else if (!isTestMode) {
            svc = this.createServiceFromLLM(rc, optional, llm);
        }
        if (this.getActivityReporter() instanceof ActivityReporter.Stream) {
            ((ActivityReporter.Stream)this.getActivityReporter()).setProxyConnector(this::connectProxy);
        }
        try (NoThrowAutoCloseable proxy = this.getActivityReporter().proxyActivities(svc);){
            this.run(config, svc);
        }
    }

    private RemoteService createServiceFromLLM(RemoteConfig rc, boolean optional, LocalLoginManager llm) {
        RemoteService svc = rc.useLogin() != null ? llm.getNamedService(rc.useLogin()) : llm.getCurrentService();
        if (!optional && svc == null) {
            this.helpAndFail("Need either --tokenFile, --token or --keystore arguments or a current login session to access remote service");
        }
        return svc;
    }

    private RemoteService createServiceFromCli(RemoteConfig rc, boolean optional) {
        URI r = null;
        if (rc.remote() != null) {
            r = UriBuilder.fromUri(rc.remote()).build(new Object[0]);
        }
        if (rc.tokenFile() != null && rc.token() != null) {
            this.out().println("WARNING: both tokenFile and token are given, preferring tokenFile (Hint: check arguments and environment)");
        }
        RemoteService svc = this.createRemoteService(rc, optional, r);
        return svc;
    }

    private NoThrowAutoCloseable connectProxy(final RemoteService remote, final Consumer<byte[]> onMessage) {
        return new NoThrowAutoCloseable(){
            private AsyncHttpClient client;
            private WebSocket ws;
            {
                try {
                    this.client = JerseyClientFactory.get(remote).getWebSocketClient();
                    this.ws = (WebSocket)JerseyClientFactory.get(remote).getAuthenticatedWebSocket(this.client, Collections.emptyList(), "/activities", onMessage, e -> {
                        RemoteServiceTool.this.out().println("WebSocket error: ");
                        e.printStackTrace(RemoteServiceTool.this.out());
                    }, s2 -> RemoteServiceTool.this.out().println("Activities WebSocket disconnected")).get();
                }
                catch (InterruptedException | ExecutionException e2) {
                    RemoteServiceTool.this.out().println("Cannot initialize Acitivities WebSocket");
                    e2.printStackTrace(RemoteServiceTool.this.out());
                    Thread.currentThread().interrupt();
                }
            }

            @Override
            public void close() {
                if (this.ws != null) {
                    this.ws.close();
                }
                if (this.client != null) {
                    this.client.close();
                }
            }
        };
    }

    private RemoteService createRemoteService(RemoteConfig rc, boolean optional, URI r) {
        RemoteService svc = null;
        if (rc.tokenFile() != null) {
            try {
                String token = new String(Files.readAllBytes(Paths.get(rc.tokenFile(), new String[0])), StandardCharsets.UTF_8);
                svc = new RemoteService(r, token);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read token from " + rc.tokenFile(), e);
            }
        } else if (rc.token() != null) {
            svc = new RemoteService(r, rc.token());
        } else if (rc.keystore() != null) {
            this.helpAndFailIfMissing(rc.passphrase(), "Missing --passphrase");
            svc = new RemoteService(r, new OnDiscKeyStore(Paths.get(rc.keystore(), new String[0]), rc.passphrase()));
        } else if (!(r == null || r.getScheme() != null && r.getScheme().equals("https"))) {
            svc = r.getScheme() == null ? new RemoteService(UriBuilder.fromUri(r).scheme("file").build(new Object[0])) : new RemoteService(UriBuilder.fromUri(r).build(new Object[0]));
        } else if (!optional) {
            this.helpAndFail("Need either --tokenFile, --token or --keystore arguments to access remote service");
        }
        return svc;
    }

    protected abstract void run(T var1, RemoteService var2);

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    protected static @interface RemoteOptional {
    }

    @Configuration.Help(value="Configuration for remote access")
    private static @interface RemoteConfig {
        @Configuration.Help(value="URI of remote BHive. Supports file:, jar:file:")
        @Configuration.EnvironmentFallback(value="BDEPLOY_REMOTE")
        @Configuration.Validator(value=RemoteValidator.class)
        public String remote();

        @Configuration.Help(value="Path to keystore containing access token.")
        @Configuration.Validator(value=ExistingPathValidator.class)
        public String keystore();

        @Configuration.Help(value="Passphrase for the keystore.")
        public String passphrase();

        @Configuration.Help(value="Token for the remote access. Can be given alternatively to a keystore.")
        @Configuration.EnvironmentFallback(value="BDEPLOY_TOKEN")
        public String token();

        @Configuration.Help(value="Path to a file containing the access token. Can be given alternatively to a keystore.")
        @Configuration.EnvironmentFallback(value="BDEPLOY_TOKENFILE")
        @Configuration.Validator(value=ExistingPathValidator.class)
        public String tokenFile();

        @Configuration.Help(value="Override which named login session to use for this command.")
        @Configuration.EnvironmentFallback(value="BDEPLOY_LOGIN")
        public String useLogin();
    }
}

