/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.fs;

import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jvnet.hk2.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class FileSystemSpaceService {
    private static final Logger log = LoggerFactory.getLogger(FileSystemSpaceService.class);
    @Inject
    @Named(value="FileSystemMinSpace")
    private Provider<Long> minFreeBytes;

    public boolean hasFreeSpace(Path path) {
        try {
            FileStore store = Files.getFileStore(path);
            if (store == null || this.minFreeBytes.get() == null) {
                return true;
            }
            long free = store.getUsableSpace();
            return free > this.minFreeBytes.get();
        }
        catch (Exception e) {
            log.error("Cannot check remaining free disc space for {}", (Object)path, (Object)e);
            return true;
        }
    }
}

