/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.monitoring;

import io.bdeploy.jersey.monitoring.JerseyServerMonitoringSnapshot;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.HttpServerMonitoringConfig;
import org.glassfish.grizzly.http.server.HttpServerProbe;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

public class JerseyServerMonitor {
    private HttpServer server;
    private final LongAdder conAccepted = new LongAdder();
    private final LongAdder conClosed = new LongAdder();
    private final LongAdder conConnected = new LongAdder();
    private final LongAdder conErrored = new LongAdder();
    private final LongAdder conBytesRead = new LongAdder();
    private final LongAdder conBytesWritten = new LongAdder();
    private final AtomicLong poolCoreSize = new AtomicLong();
    private final AtomicLong poolMaxSize = new AtomicLong();
    private final AtomicLong poolCurrentSize = new AtomicLong();
    private final LongAdder poolExceeded = new LongAdder();
    private final LongAdder poolTasksQueued = new LongAdder();
    private final LongAdder poolTasksCancelled = new LongAdder();
    private final LongAdder poolTasksFinished = new LongAdder();
    private final LongAdder reqReceived = new LongAdder();
    private final LongAdder reqCompleted = new LongAdder();
    private final LongAdder reqTimedOut = new LongAdder();
    private final LongAdder reqCancelled = new LongAdder();

    public void setServer(HttpServer server) {
        this.server = server;
        this.registerProbes();
    }

    public JerseyServerMonitoringSnapshot getSnapshot() {
        JerseyServerMonitoringSnapshot snapshot = new JerseyServerMonitoringSnapshot();
        snapshot.snapshotTime = System.currentTimeMillis();
        snapshot.conAccepted = this.conAccepted.longValue();
        snapshot.conClosed = this.conClosed.longValue();
        snapshot.conConnected = this.conConnected.longValue();
        snapshot.conErrored = this.conErrored.longValue();
        snapshot.conBytesRead = this.conBytesRead.longValue();
        snapshot.conBytesWritten = this.conBytesWritten.longValue();
        snapshot.poolCoreSize = this.poolCoreSize.longValue();
        snapshot.poolMaxSize = this.poolMaxSize.longValue();
        snapshot.poolCurrentSize = this.poolCurrentSize.longValue();
        snapshot.poolExceeded = this.poolExceeded.longValue();
        snapshot.poolTasksQueued = this.poolTasksQueued.longValue();
        snapshot.poolTasksCancelled = this.poolTasksCancelled.longValue();
        snapshot.poolTasksFinished = this.poolTasksFinished.longValue();
        snapshot.reqReceived = this.reqReceived.longValue();
        snapshot.reqCompleted = this.reqCompleted.longValue();
        snapshot.reqTimedOut = this.reqTimedOut.longValue();
        snapshot.reqCancelled = this.reqCancelled.longValue();
        snapshot.vmThreads = ManagementFactory.getThreadMXBean().getThreadCount();
        snapshot.vmCpus = Runtime.getRuntime().availableProcessors();
        snapshot.vmMaxMem = Runtime.getRuntime().maxMemory();
        snapshot.vmFreeMem = Runtime.getRuntime().freeMemory();
        snapshot.vmTotalMem = Runtime.getRuntime().totalMemory();
        return snapshot;
    }

    private void registerProbes() {
        HttpServerMonitoringConfig monitoringConfig = this.server.getServerConfiguration().getMonitoringConfig();
        monitoringConfig.getConnectionConfig().addProbes((ConnectionProbe[])new ConnectionProbe[]{new ConnectionProbe.Adapter(){

            @Override
            public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
                JerseyServerMonitor.this.conAccepted.increment();
            }

            @Override
            public void onCloseEvent(Connection connection) {
                JerseyServerMonitor.this.conClosed.increment();
            }

            @Override
            public void onConnectEvent(Connection connection) {
                JerseyServerMonitor.this.conConnected.increment();
            }

            @Override
            public void onErrorEvent(Connection connection, Throwable error) {
                JerseyServerMonitor.this.conErrored.increment();
            }

            @Override
            public void onReadEvent(Connection connection, Buffer data, int size) {
                JerseyServerMonitor.this.conBytesRead.add(size);
            }

            @Override
            public void onWriteEvent(Connection connection, Buffer data, long size) {
                JerseyServerMonitor.this.conBytesWritten.add(size);
            }
        }});
        monitoringConfig.getThreadPoolConfig().addProbes((ThreadPoolProbe[])new ThreadPoolProbe[]{new ThreadPoolProbe.Adapter(){

            @Override
            public void onThreadPoolStartEvent(AbstractThreadPool threadPool) {
                ThreadPoolConfig config = threadPool.getConfig();
                JerseyServerMonitor.this.poolCoreSize.set(config.getCorePoolSize());
                JerseyServerMonitor.this.poolMaxSize.set(config.getMaxPoolSize());
            }

            @Override
            public void onMaxNumberOfThreadsEvent(AbstractThreadPool threadPool, int maxNumberOfThreads) {
                JerseyServerMonitor.this.poolExceeded.increment();
            }

            @Override
            public void onTaskCancelEvent(AbstractThreadPool threadPool, Runnable task) {
                JerseyServerMonitor.this.poolTasksCancelled.increment();
            }

            @Override
            public void onTaskCompleteEvent(AbstractThreadPool threadPool, Runnable task) {
                JerseyServerMonitor.this.poolTasksFinished.increment();
            }

            @Override
            public void onTaskQueueEvent(AbstractThreadPool threadPool, Runnable task) {
                JerseyServerMonitor.this.poolTasksQueued.increment();
            }

            @Override
            public void onTaskDequeueEvent(AbstractThreadPool threadPool, Runnable task) {
                JerseyServerMonitor.this.poolTasksQueued.decrement();
            }

            @Override
            public void onThreadAllocateEvent(AbstractThreadPool threadPool, Thread thread) {
                JerseyServerMonitor.this.poolCurrentSize.set(threadPool.getSize());
            }

            @Override
            public void onThreadReleaseEvent(AbstractThreadPool threadPool, Thread thread) {
                JerseyServerMonitor.this.poolCurrentSize.set(threadPool.getSize());
            }
        }});
        monitoringConfig.getWebServerConfig().addProbes((HttpServerProbe[])new HttpServerProbe[]{new HttpServerProbe.Adapter(){

            @Override
            public void onRequestReceiveEvent(HttpServerFilter filter, Connection connection, Request request) {
                JerseyServerMonitor.this.reqReceived.increment();
            }

            @Override
            public void onRequestCancelEvent(HttpServerFilter filter, Connection connection, Request request) {
                JerseyServerMonitor.this.reqCancelled.increment();
            }

            @Override
            public void onRequestTimeoutEvent(HttpServerFilter filter, Connection connection, Request request) {
                JerseyServerMonitor.this.reqTimedOut.increment();
            }

            @Override
            public void onRequestCompleteEvent(HttpServerFilter filter, Connection connection, Response response) {
                JerseyServerMonitor.this.reqCompleted.increment();
            }
        }});
    }
}

