/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.monitoring;

import com.google.common.collect.EvictingQueue;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import io.bdeploy.jersey.monitoring.JerseyServerMonitor;
import io.bdeploy.jersey.monitoring.JerseyServerMonitoringDto;
import io.bdeploy.jersey.monitoring.JerseyServerMonitoringSnapshot;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class JerseyServerMonitoringSamplerService {
    private static final int MAX_SNAPSHOTS = 60;
    private final ScheduledExecutorService sampler;
    private final EvictingQueue<JerseyServerMonitoringSnapshot> snapshots = EvictingQueue.create(60);
    private final JerseyServerMonitor monitor;

    public JerseyServerMonitoringSamplerService(JerseyServerMonitor monitor) {
        this.monitor = monitor;
        this.sampler = Executors.newSingleThreadScheduledExecutor(new NamedDaemonThreadFactory("Monitoring Sampler"));
        this.sampler.scheduleAtFixedRate(this::performSnapshot, 0L, 1L, TimeUnit.MINUTES);
    }

    private void performSnapshot() {
        if (this.monitor != null) {
            this.snapshots.add(this.monitor.getSnapshot());
        }
    }

    public JerseyServerMonitoringDto getSamples() {
        JerseyServerMonitoringDto dto = new JerseyServerMonitoringDto();
        dto.snapshots = new ArrayList<JerseyServerMonitoringSnapshot>(this.snapshots);
        return dto;
    }
}

