/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.resources;

import io.bdeploy.common.metrics.Metrics;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/metrics")
@Produces(value={"application/json"})
public interface JerseyMetricsResource {
    @GET
    public Map<Metrics.MetricGroup, MetricBundle> getAllMetrics();

    public static class HistogramFields {
        public long min;
        public long max;
        public double mean;
        public double stdDev;
        public double median;
        public double p75th;
        public double p95th;
        public double p98th;
        public double p99th;
        public double p999th;
        public long size;
        public long[] values;
    }

    public static class MeterFields {
        public double meanRate;
        public double oneMinRate;
        public double fiveMinRate;
        public double fifteenMinRate;
    }

    public static class CounterFields {
        public long value;
    }

    public static class MeterMetric {
        public CounterFields counter = new CounterFields();
        public MeterFields meter = new MeterFields();
    }

    public static class GaugeMetric<T> {
        public T value;
    }

    public static class TimerMetric {
        public CounterFields counter = new CounterFields();
        public MeterFields meter = new MeterFields();
        public HistogramFields histogram = new HistogramFields();
    }

    public static class HistogramMetric {
        public CounterFields counter = new CounterFields();
        public HistogramFields histogram = new HistogramFields();
    }

    public static class CounterMetric {
        public CounterFields counter = new CounterFields();
    }

    public static class MetricBundle {
        public SortedMap<String, CounterMetric> counters = new TreeMap<String, CounterMetric>();
        public SortedMap<String, HistogramMetric> histograms = new TreeMap<String, HistogramMetric>();
        public SortedMap<String, TimerMetric> timers = new TreeMap<String, TimerMetric>();
        public SortedMap<String, GaugeMetric<?>> gauges = new TreeMap();
        public SortedMap<String, MeterMetric> meters = new TreeMap<String, MeterMetric>();
    }
}

