/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.resources;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.bdeploy.common.metrics.Metrics;
import io.bdeploy.jersey.resources.JerseyMetricsResource;
import java.util.Map;
import java.util.TreeMap;

public class JerseyMetricsResourceImpl
implements JerseyMetricsResource {
    @Override
    public Map<Metrics.MetricGroup, JerseyMetricsResource.MetricBundle> getAllMetrics() {
        TreeMap<Metrics.MetricGroup, JerseyMetricsResource.MetricBundle> allBundles = new TreeMap<Metrics.MetricGroup, JerseyMetricsResource.MetricBundle>();
        for (Metrics.MetricGroup group : Metrics.MetricGroup.values()) {
            MetricRegistry reg = Metrics.getMetric(group);
            if (reg == null) continue;
            allBundles.put(group, this.getMetricBundle(reg));
        }
        return allBundles;
    }

    private JerseyMetricsResource.MetricBundle getMetricBundle(MetricRegistry reg) {
        JerseyMetricsResource.MetricBundle bundle = new JerseyMetricsResource.MetricBundle();
        for (Map.Entry<String, Metric> entry : reg.getMetrics().entrySet()) {
            Metric m3 = entry.getValue();
            if (m3 instanceof Counter) {
                bundle.counters.put(entry.getKey(), this.readCounter((Counter)m3));
                continue;
            }
            if (m3 instanceof Meter) {
                bundle.meters.put(entry.getKey(), this.readMeter((Meter)m3));
                continue;
            }
            if (m3 instanceof Timer) {
                bundle.timers.put(entry.getKey(), this.readTimer((Timer)m3));
                continue;
            }
            if (m3 instanceof Gauge) {
                bundle.gauges.put(entry.getKey(), this.readGauge((Gauge)m3));
                continue;
            }
            if (!(m3 instanceof Histogram)) continue;
            bundle.histograms.put(entry.getKey(), this.readHistogram((Histogram)m3));
        }
        return bundle;
    }

    private JerseyMetricsResource.HistogramMetric readHistogram(Histogram m3) {
        JerseyMetricsResource.HistogramMetric hm = new JerseyMetricsResource.HistogramMetric();
        this.updateFields(hm.counter, m3);
        this.updateFields(hm.histogram, m3);
        return hm;
    }

    private <T> JerseyMetricsResource.GaugeMetric<T> readGauge(Gauge<T> m3) {
        JerseyMetricsResource.GaugeMetric gm = new JerseyMetricsResource.GaugeMetric();
        gm.value = m3.getValue();
        return gm;
    }

    private JerseyMetricsResource.TimerMetric readTimer(Timer m3) {
        JerseyMetricsResource.TimerMetric tm = new JerseyMetricsResource.TimerMetric();
        this.updateFields(tm.counter, (Counting)m3);
        this.updateFields(tm.meter, m3);
        this.updateFields(tm.histogram, m3);
        return tm;
    }

    private JerseyMetricsResource.MeterMetric readMeter(Meter m3) {
        JerseyMetricsResource.MeterMetric mm3 = new JerseyMetricsResource.MeterMetric();
        this.updateFields(mm3.counter, (Counting)m3);
        this.updateFields(mm3.meter, m3);
        return mm3;
    }

    private JerseyMetricsResource.CounterMetric readCounter(Counter m3) {
        JerseyMetricsResource.CounterMetric cm = new JerseyMetricsResource.CounterMetric();
        this.updateFields(cm.counter, m3);
        return cm;
    }

    private void updateFields(JerseyMetricsResource.CounterFields fields, Counting counting) {
        fields.value = counting.getCount();
    }

    private void updateFields(JerseyMetricsResource.MeterFields fields, Metered metered) {
        fields.meanRate = metered.getMeanRate();
        fields.oneMinRate = metered.getOneMinuteRate();
        fields.fiveMinRate = metered.getFiveMinuteRate();
        fields.fifteenMinRate = metered.getFifteenMinuteRate();
    }

    private void updateFields(JerseyMetricsResource.HistogramFields fields, Sampling sampled) {
        Snapshot samples = sampled.getSnapshot();
        fields.min = samples.getMin();
        fields.max = samples.getMax();
        fields.mean = samples.getMean();
        fields.stdDev = samples.getStdDev();
        fields.median = samples.getMedian();
        fields.p75th = samples.get75thPercentile();
        fields.p95th = samples.get95thPercentile();
        fields.p98th = samples.get98thPercentile();
        fields.p99th = samples.get99thPercentile();
        fields.p999th = samples.get999thPercentile();
        fields.size = samples.size();
        fields.values = samples.getValues();
    }
}

