/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.jersey.ws;

import io.bdeploy.common.security.ApiAccessToken;
import io.bdeploy.common.util.JacksonHelper;
import io.bdeploy.jersey.JerseyAuthenticationProvider;
import io.bdeploy.jersey.ws.JerseyEventBroadcaster;
import io.bdeploy.jersey.ws.WebSocketInitDto;
import java.io.IOException;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.OptimizedBroadcaster;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastingAuthenticatedWebSocket
extends WebSocketApplication
implements JerseyEventBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(BroadcastingAuthenticatedWebSocket.class);
    private final Broadcaster broadcaster;
    private final Function<Object, byte[]> serializer;
    private final KeyStore authStore;
    private final ScheduledExecutorService autoCloser = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentMap<WebSocket, List<String>> webSockets = new ConcurrentHashMap<WebSocket, List<String>>();

    public BroadcastingAuthenticatedWebSocket(Function<Object, byte[]> serializer, KeyStore authStore) {
        this.serializer = serializer;
        this.authStore = authStore;
        this.broadcaster = new OptimizedBroadcaster();
    }

    @Override
    public void send(Object message, List<String> scope) {
        this.broadcaster.broadcast(this.getWebSockets(scope), this.serializer.apply(message));
    }

    @Override
    public void onConnect(final WebSocket socket) {
        final ScheduledFuture<?> schedule = this.autoCloser.schedule(() -> socket.close(Response.Status.UNAUTHORIZED.getStatusCode(), "No Token received"), 5L, TimeUnit.SECONDS);
        socket.add(new WebSocketAdapter(){

            @Override
            public void onMessage(WebSocket s2, String text) {
                WebSocketInitDto init;
                try {
                    init = JacksonHelper.createObjectMapper(JacksonHelper.MapperType.JSON).readValue(text, WebSocketInitDto.class);
                }
                catch (IOException e) {
                    log.error("Cannot read WebSocket init DTO", e);
                    s2.close(Response.Status.UNAUTHORIZED.getStatusCode(), "Invalid Init Message");
                    return;
                }
                ApiAccessToken token = null;
                try {
                    token = JerseyAuthenticationProvider.validateToken(init.token, BroadcastingAuthenticatedWebSocket.this.authStore);
                }
                catch (Exception e) {
                    log.error("Cannot parse authentication token: ", e);
                }
                schedule.cancel(false);
                if (token == null) {
                    log.warn("Invalid authentication from client, closing");
                    s2.close(Response.Status.UNAUTHORIZED.getStatusCode(), "Invalid Authentication Token");
                } else {
                    socket.remove(this);
                    BroadcastingAuthenticatedWebSocket.this.add(socket, init.scope);
                }
            }
        });
    }

    private boolean add(WebSocket socket, List<String> scopes) {
        return this.webSockets.put(socket, scopes) == null;
    }

    @Override
    public boolean remove(WebSocket socket) {
        return this.webSockets.remove(socket) != null;
    }

    private Set<WebSocket> getWebSockets(List<String> scope) {
        return this.webSockets.entrySet().stream().filter(e -> {
            if (((List)e.getValue()).size() > scope.size()) {
                return false;
            }
            for (int i = 0; i < ((List)e.getValue()).size(); ++i) {
                if (((String)((List)e.getValue()).get(i)).equals(scope.get(i))) continue;
                return false;
            }
            return true;
        }).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

