/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.listenable.AbstractListenableFuture;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.utils.Futures;

final class GrizzlyResponseFuture<V>
extends AbstractListenableFuture<V>
implements CompletionHandler<V> {
    private final FutureImpl<V> delegate;
    private AsyncHandler asyncHandler;
    private volatile HttpTransactionContext transactionCtx;

    GrizzlyResponseFuture(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
        this.delegate = Futures.createSafeFuture();
        this.delegate.addCompletionHandler(this);
    }

    @Override
    public void done() {
        this.done(null);
    }

    public void done(V result) {
        this.delegate.result(result);
    }

    @Override
    public void abort(Throwable t) {
        this.delegate.failure(t);
    }

    @Override
    public void touch() {
        HttpTransactionContext tx = this.transactionCtx;
        if (tx != null) {
            tx.touchConnection();
        }
    }

    public boolean getAndSetWriteHeaders(boolean writeHeaders) {
        return writeHeaders;
    }

    public boolean getAndSetWriteBody(boolean writeBody) {
        return writeBody;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.get(timeout, unit);
    }

    @Override
    public void cancelled() {
        AsyncHandler ah = this.asyncHandler;
        if (ah != null) {
            try {
                ah.onThrowable(new CancellationException());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.runListeners();
    }

    @Override
    public void failed(Throwable t) {
        HttpTransactionContext tx;
        AsyncHandler ah = this.asyncHandler;
        if (ah != null) {
            try {
                ah.onThrowable(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((tx = this.transactionCtx) != null) {
            tx.closeConnection();
        }
        this.runListeners();
    }

    @Override
    public void completed(V result) {
        this.runListeners();
    }

    @Override
    public void updated(V result) {
    }

    AsyncHandler getAsyncHandler() {
        return this.asyncHandler;
    }

    void setAsyncHandler(AsyncHandler asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    HttpTransactionContext getHttpTransactionCtx() {
        return this.transactionCtx;
    }

    boolean setHttpTransactionCtx(HttpTransactionContext transactionCtx) {
        this.transactionCtx = transactionCtx;
        return !this.delegate.isDone();
    }
}

