/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.product.v1;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.ArrayList;
import java.util.List;

@JsonClassDescription(value="Describes a product (name, key, included applications, capabilities, ...). Only includes the build/version independent configuration.")
public class ProductDescriptor {
    @JsonPropertyDescription(value="The human readable name of the product.")
    @JsonProperty(required=true)
    public String name;
    @JsonPropertyDescription(value="The (path-friendly) ID of the product, e.g. 'io.bdeploy/product'")
    @JsonProperty(required=true)
    public String product;
    @JsonPropertyDescription(value="The name of the vendor of the product.")
    public String vendor;
    @JsonPropertyDescription(value="A list of applications included in the product. Those applications must be available at build time, provided through 'product-version.yaml'.")
    @JsonProperty(required=true)
    public List<String> applications = new ArrayList<String>();
    @JsonPropertyDescription(value="A relative path (from product-info.yaml) to a directory containing an arbitrary amount of configuration files used as templates for new instances.")
    public String configTemplates;
    @JsonPropertyDescription(value="A relative path (from product-info.yaml) to a directory containing plugins which are to be made available dynamically when configuring an instance using this product.")
    public String pluginFolder;
    @JsonAlias(value={"templates"})
    @JsonPropertyDescription(value="A list of relative paths to ('instance-template.yaml') YAML files containing instance templates.")
    public List<String> instanceTemplates = new ArrayList<String>();
    @JsonPropertyDescription(value="A list of relative paths to ('application-template.yaml') YAML files containing application templates.")
    public List<String> applicationTemplates = new ArrayList<String>();
    @JsonPropertyDescription(value="A list of relative paths to ('parameter-template.yaml') YAML files containing parameter templates.")
    public List<String> parameterTemplates = new ArrayList<String>();
    @JsonPropertyDescription(value="A list of relative paths to ('instance-variable-template.yaml') YAML files containing instance variable templates.")
    public List<String> instanceVariableTemplates = new ArrayList<String>();
    @JsonPropertyDescription(value="A relative path to the mandatory 'product-version.yaml' file which defines versions and available applications.")
    public String versionFile;
}

