/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.product.v1;

import io.bdeploy.api.product.v1.ApplicationDescriptorApi;
import io.bdeploy.api.product.v1.DependencyFetcher;
import io.bdeploy.api.product.v1.ProductDescriptor;
import io.bdeploy.api.product.v1.ProductVersionDescriptor;
import io.bdeploy.api.product.v1.impl.ScopedManifestKey;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ImportFileOperation;
import io.bdeploy.bhive.op.ImportObjectOperation;
import io.bdeploy.bhive.op.ImportOperation;
import io.bdeploy.bhive.op.ImportTreeOperation;
import io.bdeploy.bhive.op.InsertArtificialTreeOperation;
import io.bdeploy.bhive.op.InsertManifestOperation;
import io.bdeploy.bhive.op.InsertManifestRefOperation;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ObjectLoadOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.util.OsHelper;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ProductManifestBuilder {
    public static final String PRODUCT_LABEL = "X-Product";
    public static final String PRODUCT_DESC = "product.json";
    public static final String CONFIG_ENTRY = "config";
    public static final String PLUGINS_ENTRY = "plugins";
    public static final String TEMPLATES_ENTRY = "templates";
    public static final String APP_TEMPLATES_ENTRY = "appTemplates";
    public static final String PARAM_TEMPLATES_ENTRY = "paramTemplates";
    public static final String VARIABLE_TEMPLATES_ENTRY = "variableTemplates";
    private final Map<String, Manifest.Key> applications = new TreeMap<String, Manifest.Key>();
    private final Map<String, String> labels = new TreeMap<String, String>();
    private final ProductDescriptor desc;
    private Path configTemplates;
    private Path pluginFolder;
    private final List<Path> instanceTemplates = new ArrayList<Path>();
    private final List<Path> appTemplates = new ArrayList<Path>();
    private final List<Path> paramTemplates = new ArrayList<Path>();
    private final List<Path> varTemplates = new ArrayList<Path>();

    public ProductManifestBuilder(ProductDescriptor desc) {
        this.desc = desc;
    }

    public synchronized ProductManifestBuilder add(Manifest.Key application) {
        this.applications.put(application.directoryFriendlyName(), application);
        return this;
    }

    public synchronized ProductManifestBuilder setConfigTemplates(Path templates) {
        this.configTemplates = templates;
        return this;
    }

    public synchronized ProductManifestBuilder setPluginFolder(Path plugins) {
        this.pluginFolder = plugins;
        return this;
    }

    public synchronized ProductManifestBuilder addLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    public synchronized ProductManifestBuilder addInstanceTemplate(Path tmplPath) {
        this.instanceTemplates.add(tmplPath);
        return this;
    }

    public synchronized ProductManifestBuilder addApplicationTemplate(Path tmplPath) {
        this.appTemplates.add(tmplPath);
        return this;
    }

    public synchronized ProductManifestBuilder addParameterTemplate(Path tmplPath) {
        this.paramTemplates.add(tmplPath);
        return this;
    }

    public synchronized ProductManifestBuilder addInstanceVariableTemplate(Path tmplPath) {
        this.varTemplates.add(tmplPath);
        return this;
    }

    public synchronized void insert(BHive hive, Manifest.Key manifest, String productName) {
        try (BHiveTransactions.Transaction t = hive.getTransactions().begin();){
            this.doInsertLocked(hive, manifest, productName);
        }
    }

    private void doInsertLocked(BHive hive, Manifest.Key manifest, String productName) {
        Tree.Builder tree = new Tree.Builder();
        this.applications.forEach((k, v) -> tree.add(new Tree.Key((String)k, Tree.EntryType.MANIFEST), hive.execute(new InsertManifestRefOperation().setManifest((Manifest.Key)v))));
        ObjectId descId = hive.execute(new ImportObjectOperation().setData(StorageHelper.toRawBytes(this.desc)));
        tree.add(new Tree.Key(PRODUCT_DESC, Tree.EntryType.BLOB), descId);
        if (this.configTemplates != null) {
            ObjectId configId = hive.execute(new ImportTreeOperation().setSkipEmpty(true).setSourcePath(this.configTemplates));
            tree.add(new Tree.Key(CONFIG_ENTRY, Tree.EntryType.TREE), configId);
        }
        if (this.pluginFolder != null) {
            ObjectId pluginId = hive.execute(new ImportTreeOperation().setSkipEmpty(true).setSourcePath(this.pluginFolder));
            tree.add(new Tree.Key(PLUGINS_ENTRY, Tree.EntryType.TREE), pluginId);
            TreeView tv = hive.execute(new ScanOperation().setTree(pluginId));
            tv.visit(new TreeVisitor.Builder().onBlob(b -> {
                if (b.getName().toLowerCase().endsWith(".jar")) {
                    try (JarInputStream jis = new JarInputStream(hive.execute(new ObjectLoadOperation().setObject(b.getElementId())));){
                        Manifest pluginMf = jis.getManifest();
                        if (pluginMf == null) {
                            throw new IllegalStateException("The plugin is not a valid JAR file: " + b.getName());
                        }
                        Attributes mainAttributes = pluginMf.getMainAttributes();
                        String mainClass = mainAttributes.getValue("BDeploy-Plugin");
                        String name = mainAttributes.getValue("BDeploy-PluginName");
                        if (mainClass == null || name == null) {
                            throw new IllegalStateException("The plugin must define the 'BDeploy-Plugin' and 'BDeploy-PluginName' headers: " + b.getName());
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("The plugin cannot be read: " + b.getName(), e);
                    }
                }
            }).build());
        }
        Tree.Builder templTree = new Tree.Builder();
        for (Path path : this.instanceTemplates) {
            ObjectId objectId = hive.execute(new ImportFileOperation().setFile(path));
            templTree.add(new Tree.Key(objectId.toString() + ".yaml", Tree.EntryType.BLOB), objectId);
        }
        tree.add(new Tree.Key(TEMPLATES_ENTRY, Tree.EntryType.TREE), hive.execute(new InsertArtificialTreeOperation().setTree(templTree)));
        Tree.Builder appTemplTree = new Tree.Builder();
        for (Path path : this.appTemplates) {
            ObjectId objectId = hive.execute(new ImportFileOperation().setFile(path));
            appTemplTree.add(new Tree.Key(objectId.toString() + ".yaml", Tree.EntryType.BLOB), objectId);
        }
        tree.add(new Tree.Key(APP_TEMPLATES_ENTRY, Tree.EntryType.TREE), hive.execute(new InsertArtificialTreeOperation().setTree(appTemplTree)));
        Tree.Builder builder = new Tree.Builder();
        for (Path path : this.paramTemplates) {
            ObjectId id = hive.execute(new ImportFileOperation().setFile(path));
            builder.add(new Tree.Key(id.toString() + ".yaml", Tree.EntryType.BLOB), id);
        }
        tree.add(new Tree.Key(PARAM_TEMPLATES_ENTRY, Tree.EntryType.TREE), hive.execute(new InsertArtificialTreeOperation().setTree(builder)));
        Tree.Builder builder2 = new Tree.Builder();
        for (Path p : this.varTemplates) {
            ObjectId id = hive.execute(new ImportFileOperation().setFile(p));
            builder2.add(new Tree.Key(id.toString() + ".yaml", Tree.EntryType.BLOB), id);
        }
        tree.add(new Tree.Key(VARIABLE_TEMPLATES_ENTRY, Tree.EntryType.TREE), hive.execute(new InsertArtificialTreeOperation().setTree(builder2)));
        Manifest.Builder builder3 = new Manifest.Builder(manifest);
        this.labels.forEach(builder3::addLabel);
        builder3.addLabel(PRODUCT_LABEL, productName).setRoot(hive.execute(new InsertArtificialTreeOperation().setTree(tree)));
        hive.execute(new InsertManifestOperation().addManifest(builder3.build(hive)));
    }

    public static Manifest.Key importFromDescriptor(Path descriptorPath, BHive hive, DependencyFetcher fetcher, boolean parallel) {
        Path tmplPath;
        descriptorPath = ProductManifestBuilder.getDescriptorPath(descriptorPath);
        descriptorPath = descriptorPath.toAbsolutePath();
        ProductDescriptor prod = ProductManifestBuilder.readProductDescriptor(descriptorPath);
        if (prod.versionFile == null || prod.versionFile.isEmpty()) {
            throw new IllegalStateException("product descriptor does not reference a product version descriptor, which is required.");
        }
        Path vDesc = descriptorPath.getParent().resolve(prod.versionFile);
        ProductVersionDescriptor versions = ProductManifestBuilder.readProductVersionDescriptor(descriptorPath, vDesc);
        RuntimeAssert.assertNotNull(versions.version, "no version defined in " + vDesc);
        RuntimeAssert.assertNotNull(prod.name, "no name defined in " + descriptorPath);
        RuntimeAssert.assertNotNull(prod.product, "no name defined in " + descriptorPath);
        TreeMap<String, Map<OsHelper.OperatingSystem, String>> toImport = new TreeMap<String, Map<OsHelper.OperatingSystem, String>>();
        ProductManifestBuilder.matchApplicationsWithDescriptor(prod, vDesc, versions, toImport);
        String baseName = prod.product + "/";
        Manifest.Key prodKey = new Manifest.Key(baseName + "product", versions.version);
        ProductManifestBuilder builder = new ProductManifestBuilder(prod);
        if (Boolean.TRUE.equals(hive.execute(new ManifestExistsOperation().setManifest(prodKey)))) {
            throw new IllegalStateException("Product " + prodKey + " is already present.");
        }
        Path impBasePath = descriptorPath.getParent();
        ProductManifestBuilder.importApplications(hive, fetcher, versions, toImport, baseName, builder, impBasePath, parallel);
        versions.labels.forEach(builder::addLabel);
        if (prod.configTemplates != null) {
            Path cfgDir = descriptorPath.getParent().resolve(prod.configTemplates);
            if (!Files.isDirectory(cfgDir, new LinkOption[0])) {
                throw new IllegalStateException("Configuration template directory not found: " + cfgDir);
            }
            builder.setConfigTemplates(cfgDir);
        }
        if (prod.pluginFolder != null) {
            Path pluginPath = descriptorPath.getParent().resolve(prod.pluginFolder);
            if (!Files.isDirectory(pluginPath, new LinkOption[0])) {
                throw new IllegalStateException("Plugin directory not found: " + pluginPath);
            }
            builder.setPluginFolder(pluginPath);
        }
        if (prod.instanceTemplates != null && !prod.instanceTemplates.isEmpty()) {
            for (String tmpl : prod.instanceTemplates) {
                tmplPath = descriptorPath.getParent().resolve(tmpl);
                if (!Files.isRegularFile(tmplPath, new LinkOption[0])) {
                    throw new IllegalStateException("Instance Template descriptor not found: " + tmplPath);
                }
                builder.addInstanceTemplate(tmplPath);
            }
        }
        if (prod.applicationTemplates != null && !prod.applicationTemplates.isEmpty()) {
            for (String tmpl : prod.applicationTemplates) {
                tmplPath = descriptorPath.getParent().resolve(tmpl);
                if (!Files.isRegularFile(tmplPath, new LinkOption[0])) {
                    throw new IllegalStateException("Application Template descriptor not found: " + tmplPath);
                }
                builder.addApplicationTemplate(tmplPath);
            }
        }
        if (prod.parameterTemplates != null && !prod.parameterTemplates.isEmpty()) {
            for (String tmpl : prod.parameterTemplates) {
                tmplPath = descriptorPath.getParent().resolve(tmpl);
                if (!Files.isRegularFile(tmplPath, new LinkOption[0])) {
                    throw new IllegalStateException("Parameter Template descriptor not found: " + tmplPath);
                }
                builder.addParameterTemplate(tmplPath);
            }
        }
        if (prod.instanceVariableTemplates != null && !prod.instanceVariableTemplates.isEmpty()) {
            for (String tmpl : prod.instanceVariableTemplates) {
                tmplPath = descriptorPath.getParent().resolve(tmpl);
                if (!Files.isRegularFile(tmplPath, new LinkOption[0])) {
                    throw new IllegalStateException("Parameter Template descriptor not found: " + tmplPath);
                }
                builder.addInstanceVariableTemplate(tmplPath);
            }
        }
        builder.insert(hive, prodKey, prod.product);
        return prodKey;
    }

    public static Path getDescriptorPath(Path descriptorPath) {
        if (Files.isDirectory(descriptorPath, new LinkOption[0])) {
            descriptorPath = descriptorPath.resolve("product-info.yaml");
        }
        return descriptorPath;
    }

    private static void matchApplicationsWithDescriptor(ProductDescriptor prod, Path vDesc, ProductVersionDescriptor versions, Map<String, Map<OsHelper.OperatingSystem, String>> toImport) {
        for (String appName : prod.applications) {
            Map<OsHelper.OperatingSystem, String> map = versions.appInfo.get(appName);
            if (map == null || map.isEmpty()) {
                throw new IllegalStateException("Cannot find build information for " + appName + " in " + vDesc);
            }
            RuntimeAssert.assertFalse("product".equals(appName), "application may not be named 'product'");
            toImport.put(appName, map);
        }
    }

    private static void importApplications(BHive hive, DependencyFetcher fetcher, ProductVersionDescriptor versions, Map<String, Map<OsHelper.OperatingSystem, String>> toImport, String baseName, ProductManifestBuilder builder, Path impBasePath, boolean parallel) {
        List<Callable<ApplicationDescriptorApi>> tasks = ProductManifestBuilder.doGatherImportTasks(hive, fetcher, versions, toImport, baseName, builder, impBasePath);
        try {
            if (parallel) {
                for (Future<ApplicationDescriptorApi> f : ForkJoinPool.commonPool().invokeAll(tasks)) {
                    f.get();
                }
            } else {
                for (Callable<ApplicationDescriptorApi> c : tasks) {
                    c.call();
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Failed to import", ie);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to import", e);
        }
    }

    private static List<Callable<ApplicationDescriptorApi>> doGatherImportTasks(BHive hive, DependencyFetcher fetcher, ProductVersionDescriptor versions, Map<String, Map<OsHelper.OperatingSystem, String>> toImport, String baseName, ProductManifestBuilder builder, Path impBasePath) {
        ArrayList<Callable<ApplicationDescriptorApi>> tasks = new ArrayList<Callable<ApplicationDescriptorApi>>();
        for (Map.Entry<String, Map<OsHelper.OperatingSystem, String>> entry : toImport.entrySet()) {
            for (Map.Entry<OsHelper.OperatingSystem, String> relApp : entry.getValue().entrySet()) {
                Path appPath = impBasePath.resolve(relApp.getValue());
                if (Files.isDirectory(appPath, new LinkOption[0])) {
                    appPath = appPath.resolve("app-info.yaml");
                }
                if (!PathHelper.exists(appPath)) {
                    throw new IllegalStateException("Cannot find " + appPath + " while importing " + entry.getKey());
                }
                Path finalAppPath = appPath;
                tasks.add(() -> ProductManifestBuilder.importDependenciesAndApplication(hive, fetcher, versions, baseName, builder, (String)entry.getKey(), (OsHelper.OperatingSystem)((Object)((Object)relApp.getKey())), finalAppPath));
            }
        }
        return tasks;
    }

    private static ApplicationDescriptorApi importDependenciesAndApplication(BHive hive, DependencyFetcher fetcher, ProductVersionDescriptor versions, String baseName, ProductManifestBuilder builder, String appName, OsHelper.OperatingSystem os, Path appPath) {
        ApplicationDescriptorApi appDesc;
        try (InputStream is = Files.newInputStream(appPath, new OpenOption[0]);){
            appDesc = StorageHelper.fromYamlStream(is, ApplicationDescriptorApi.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + appPath);
        }
        RuntimeAssert.assertTrue(appDesc.supportedOperatingSystems.contains((Object)os), "Application " + appName + " does not support operating system " + os);
        fetcher.fetch(hive, appDesc.runtimeDependencies, os).forEach(builder::add);
        try (BHiveTransactions.Transaction t = hive.getTransactions().begin();){
            builder.add(hive.execute(new ImportOperation().setSourcePath(appPath.getParent()).setManifest(new ScopedManifestKey(baseName + appName, os, versions.version).getKey())));
        }
        return appDesc;
    }

    public static ProductVersionDescriptor readProductVersionDescriptor(Path impDesc, Path vDesc) {
        ProductVersionDescriptor versions;
        if (!PathHelper.exists(vDesc)) {
            throw new IllegalStateException("Cannot find version descriptor at " + vDesc);
        }
        try (InputStream is = Files.newInputStream(vDesc, new OpenOption[0]);){
            versions = StorageHelper.fromYamlStream(is, ProductVersionDescriptor.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + impDesc, e);
        }
        return versions;
    }

    public static ProductDescriptor readProductDescriptor(Path impDesc) {
        ProductDescriptor prod;
        if (!PathHelper.exists(impDesc)) {
            throw new IllegalArgumentException("Product descriptor does not exist: " + impDesc);
        }
        try (InputStream is = Files.newInputStream(impDesc, new OpenOption[0]);){
            prod = StorageHelper.fromYamlStream(is, ProductDescriptor.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + impDesc, e);
        }
        return prod;
    }
}

