/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.product.v1.impl;

import io.bdeploy.api.product.v1.DependencyFetcher;
import io.bdeploy.api.product.v1.impl.LocalDependencyFetcher;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.common.util.OsHelper;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class MultiLocalDependencyFetcher
implements DependencyFetcher {
    private final List<BHive> sources;

    public MultiLocalDependencyFetcher(List<BHive> sources) {
        this.sources = sources;
    }

    @Override
    public SortedSet<Manifest.Key> fetch(BHive target, SortedSet<String> specs, OsHelper.OperatingSystem os) {
        TreeSet<Manifest.Key> smks = new TreeSet<Manifest.Key>();
        for (String dep : specs) {
            smks.add(this.resolveDependency(target, dep, os));
        }
        return smks;
    }

    private Manifest.Key resolveDependency(BHive target, String dep, OsHelper.OperatingSystem os) {
        Manifest.Key resolved = LocalDependencyFetcher.resolveSingleLocal(target, dep, os);
        if (resolved != null) {
            return resolved;
        }
        for (BHive source : this.sources) {
            resolved = LocalDependencyFetcher.resolveSingleLocal(source, dep, os);
            if (resolved == null) continue;
            this.copyDependency(source, target, resolved);
            return resolved;
        }
        throw new IllegalStateException("Cannot resolve dependency " + dep + " for " + os);
    }

    private void copyDependency(BHive source, BHive target, Manifest.Key resolved) {
        Set<ObjectId> objectIds = source.execute(new ObjectListOperation().addManifest(resolved));
        CopyOperation op = new CopyOperation().setDestinationHive(target).addManifest(resolved).addObject(objectIds);
        source.execute(op);
    }
}

