/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.product.v1.impl;

import io.bdeploy.api.product.v1.DependencyFetcher;
import io.bdeploy.api.product.v1.impl.LocalDependencyFetcher;
import io.bdeploy.api.product.v1.impl.ScopedManifestKey;
import io.bdeploy.api.remote.v1.PublicRootResource;
import io.bdeploy.api.remote.v1.dto.SoftwareRepositoryConfigurationApi;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.remote.FetchOperation;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.OsHelper;
import io.bdeploy.jersey.JerseyClientFactory;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class RemoteDependencyFetcher
implements DependencyFetcher {
    private final RemoteService svc;
    private final String instanceGroup;
    private final ActivityReporter reporter;

    public RemoteDependencyFetcher(RemoteService svc, String instanceGroup, ActivityReporter reporter) {
        this.svc = svc;
        this.instanceGroup = instanceGroup;
        this.reporter = reporter;
    }

    @Override
    public synchronized SortedSet<Manifest.Key> fetch(BHive hive, SortedSet<String> deps, OsHelper.OperatingSystem os) {
        String group = this.instanceGroup;
        SortedSet<String> remaining = new TreeSet<String>();
        TreeSet<Manifest.Key> passOne = new TreeSet<Manifest.Key>();
        for (String dep : deps) {
            Manifest.Key resolved = LocalDependencyFetcher.resolveSingleLocal(hive, dep, os);
            if (resolved == null) {
                remaining.add(dep);
                continue;
            }
            passOne.add(resolved);
        }
        if (remaining.isEmpty()) {
            return passOne;
        }
        if (group != null) {
            try (ActivityReporter.Activity resolving = this.reporter.start("Resolving " + remaining.size() + " dependencies from instance group " + group);){
                remaining = this.fetchSingleRemote(hive, remaining, os, group);
            }
        }
        if (!remaining.isEmpty()) {
            PublicRootResource root = JerseyClientFactory.get(this.svc).getProxyClient(PublicRootResource.class, new Object[0]);
            for (SoftwareRepositoryConfigurationApi repo : root.getSoftwareRepositories()) {
                try (ActivityReporter.Activity resolving = this.reporter.start("Resolving " + remaining.size() + " dependencies from repository " + repo.name + " (" + repo.description + ")");){
                    remaining = this.fetchSingleRemote(hive, remaining, os, repo.name);
                }
                if (!remaining.isEmpty()) continue;
                break;
            }
        }
        return new LocalDependencyFetcher().fetch(hive, deps, os);
    }

    private SortedSet<String> fetchSingleRemote(BHive hive, SortedSet<String> deps, OsHelper.OperatingSystem os, String group) {
        TreeSet<Manifest.Key> toFetch = new TreeSet<Manifest.Key>();
        TreeSet<String> unresolved = new TreeSet<String>();
        for (String dep : deps) {
            boolean found = false;
            if (!dep.contains(":")) {
                throw new IllegalStateException("Dependency must have a tag ('name:tag'): " + dep);
            }
            found = this.findOnRemote(os, group, toFetch, dep);
            if (found) continue;
            unresolved.add(dep);
        }
        if (toFetch.isEmpty()) {
            return unresolved;
        }
        try (BHiveTransactions.Transaction t = hive.getTransactions().begin();){
            hive.execute(((FetchOperation)new FetchOperation().setRemote(this.svc)).setHiveName(group).addManifest(toFetch));
        }
        return unresolved;
    }

    private boolean findOnRemote(OsHelper.OperatingSystem os, String group, SortedSet<Manifest.Key> toFetch, String dep) {
        Manifest.Key k = Manifest.Key.parse(dep);
        try (RemoteBHive rbh = RemoteBHive.forService(this.svc, group, this.reporter);){
            SortedMap<Manifest.Key, ObjectId> rmi = rbh.getManifestInventory(k.getName());
            List available = rmi.keySet().stream().filter(rk -> rk.getTag().equals(k.getTag())).collect(Collectors.toList());
            for (Manifest.Key rk2 : available) {
                ScopedManifestKey smk = ScopedManifestKey.parse(rk2);
                if (smk == null || smk.getOperatingSystem() != os) continue;
                toFetch.add(smk.getKey());
                boolean bl = true;
                return bl;
            }
            for (Manifest.Key rk2 : available) {
                if (!rk2.equals(k)) continue;
                toFetch.add(k);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

