/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.remote.v1;

import io.bdeploy.api.remote.v1.PublicInstanceResource;
import io.bdeploy.api.remote.v1.dto.CredentialsApi;
import io.bdeploy.api.remote.v1.dto.InstanceGroupConfigurationApi;
import io.bdeploy.api.remote.v1.dto.SoftwareRepositoryConfigurationApi;
import io.bdeploy.jersey.ActivityScope;
import io.bdeploy.jersey.JerseyAuthenticationProvider;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Info;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@OpenAPIDefinition(info=@Info(title="BDeploy Public Master API", version="1", description="BDeploy backend APIs for public use. Callers must set the X-BDeploy-Authorization header to be able to access APIs. This token can be obtained through the CLI and the Web UI. The API is exposed on any BDeploy master (regardless of its mode) on the '/api' namespace (e.g. 'https://localhost:7701/api/public/v1/...')"))
@Path(value="/public/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface PublicRootResource {
    @Operation(summary="Get BDeploy Server Version", description="Retrieve the version of the running BDeploy server.")
    @GET
    @JerseyAuthenticationProvider.WeakTokenAllowed
    @Path(value="/version")
    public String getVersion();

    @Deprecated
    @Operation(summary="Login to a BDeploy Server", description="Uses given credentials to create a token for the BDeploy server. This token can be used by tooling to perform communication with the server on behalf of the given user. The 'full' parameter controls the type of token returned. Most tools require a full token.")
    @GET
    @JerseyAuthenticationProvider.Unsecured
    @Path(value="/login")
    public Response login(@QueryParam(value="user") String var1, @QueryParam(value="pass") String var2, @QueryParam(value="full") boolean var3);

    @Operation(summary="Login to a BDeploy Server", description="Uses given credentials to create a token for the BDeploy server. This token can be used by tooling to perform communication with the server on behalf of the given user. The 'full' parameter controls the type of token returned. Most tools require a full token. This new avoids query parameters.")
    @POST
    @JerseyAuthenticationProvider.Unsecured
    @Path(value="/login2")
    public Response login2(CredentialsApi var1, @QueryParam(value="full") boolean var2);

    @Operation(summary="Get Software Repositories", description="Retrieve a list of all available Software Repositories which may be used to resolve product dependencies at build time.")
    @GET
    @Path(value="/softwareRepositories")
    public List<SoftwareRepositoryConfigurationApi> getSoftwareRepositories();

    @Operation(summary="Get Instance Groups", description="Retrieve a list of all available Instance Groups on the server.")
    @GET
    @Path(value="/instanceGroups")
    public List<InstanceGroupConfigurationApi> getInstanceGroups();

    @Operation(summary="Get instance group by instance ID", description="Get instance group containing instance with the given instance ID")
    @GET
    @Path(value="/groupForInstance")
    public InstanceGroupConfigurationApi getInstanceGroupByInstanceId(@QueryParam(value="instanceId") String var1);

    @Operation
    @Path(value="/common")
    public PublicInstanceResource getInstanceResource(@Parameter(description="The name of the instance group to access") @ActivityScope @QueryParam(value="BDeploy_group") String var1);
}

