/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.validation.v1;

import io.bdeploy.api.product.v1.ProductDescriptor;
import io.bdeploy.api.validation.v1.dto.ProductValidationDescriptorApi;
import io.bdeploy.api.validation.v1.dto.ProductValidationIssueApi;
import io.bdeploy.api.validation.v1.dto.ProductValidationResponseApi;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.jersey.JerseyClientFactory;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;

public class ProductValidationHelper {
    private ProductValidationHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductValidationResponseApi validate(Path descriptor, RemoteService remote) {
        ProductValidationDescriptorApi desc = ProductValidationHelper.parseDescriptor(descriptor);
        Path zipFile = ProductValidationHelper.zipFiles(descriptor.toAbsolutePath().getParent(), desc);
        try {
            ProductValidationResponseApi productValidationResponseApi = ProductValidationHelper.validateRemote(remote, zipFile);
            return productValidationResponseApi;
        }
        finally {
            PathHelper.deleteRecursive(zipFile);
        }
    }

    private static ProductValidationDescriptorApi parseDescriptor(Path descriptor) {
        ProductValidationDescriptorApi productValidationDescriptorApi;
        block8: {
            InputStream is = Files.newInputStream(descriptor, new OpenOption[0]);
            try {
                productValidationDescriptorApi = StorageHelper.fromYamlStream(is, ProductValidationDescriptorApi.class);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot parse " + descriptor, e);
                }
            }
            is.close();
        }
        return productValidationDescriptorApi;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Path zipFiles(Path dir, ProductValidationDescriptorApi originalDescriptor) {
        Path zipFile;
        try {
            zipFile = Files.createTempFile("validation_", ".zip", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp file", e);
        }
        ProductValidationDescriptorApi zippedDescriptor = new ProductValidationDescriptorApi();
        Function<String, Path> toPath = f -> dir.resolve((String)f).toAbsolutePath();
        HashSet<String> dirEntries = new HashSet<String>();
        try (OutputStream fos = Files.newOutputStream(zipFile, new OpenOption[0]);){
            Path path;
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                Path productSrcFile = toPath.apply(originalDescriptor.product);
                if (!Files.isRegularFile(productSrcFile, new LinkOption[0])) {
                    throw new IllegalStateException("Product validation descriptor is not a file: " + productSrcFile);
                }
                zippedDescriptor.product = ProductValidationHelper.copyIntoZip(productSrcFile, zos, dirEntries);
                ProductValidationHelper.zipProductInfoReferences(productSrcFile, zos, dirEntries);
                Map<Object, Object> applications = originalDescriptor.applications == null ? Collections.emptyMap() : originalDescriptor.applications;
                for (Map.Entry<Object, Object> entry : applications.entrySet()) {
                    String application = (String)entry.getKey();
                    String appFileName = (String)entry.getValue();
                    Path applicationSrcFile = toPath.apply(appFileName);
                    if (!Files.isRegularFile(applicationSrcFile, new LinkOption[0])) {
                        throw new IllegalStateException("Application descriptor for '" + application + "' is not a file: " + applicationSrcFile);
                    }
                    String applicationTargetFilename = application + "_" + applicationSrcFile.getFileName();
                    String applicationTargetFile = ProductValidationHelper.copyIntoZip(applicationSrcFile, applicationTargetFilename, zos, dirEntries);
                    zippedDescriptor.applications.put(application, applicationTargetFile);
                }
                try (ByteArrayInputStream is = new ByteArrayInputStream(StorageHelper.toRawYamlBytes(zippedDescriptor));){
                    ProductValidationHelper.copyIntoZip(is, "descriptor.yaml", zos, dirEntries);
                }
                path = zipFile;
            }
            return path;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create ZIP file " + zipFile, e);
        }
    }

    private static void zipProductInfoReferences(Path productInfoPath, ZipOutputStream zos, Set<String> dirEntries) {
        try (InputStream is = Files.newInputStream(productInfoPath, new OpenOption[0]);){
            ProductDescriptor prod = StorageHelper.fromYamlStream(is, ProductDescriptor.class);
            List paths = Stream.of(prod.applicationTemplates, prod.instanceTemplates, prod.instanceVariableTemplates, prod.parameterTemplates).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            for (String pathStr : paths) {
                Path path = productInfoPath.getParent().resolve(pathStr);
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new IllegalStateException("Descriptor referenced from product is not a file: " + path);
                }
                ProductValidationHelper.copyIntoZip(path, pathStr, zos, dirEntries);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + productInfoPath, e);
        }
    }

    private static String copyIntoZip(Path srcFile, ZipOutputStream zos, Set<String> dirEntries) throws IOException {
        try (InputStream fis = Files.newInputStream(srcFile, new OpenOption[0]);){
            String string = ProductValidationHelper.copyIntoZip(fis, srcFile.getFileName().toString(), zos, dirEntries);
            return string;
        }
    }

    private static String copyIntoZip(Path srcFile, String targetFilename, ZipOutputStream zos, Set<String> dirEntries) throws IOException {
        try (InputStream fis = Files.newInputStream(srcFile, new OpenOption[0]);){
            String string = ProductValidationHelper.copyIntoZip(fis, targetFilename, zos, dirEntries);
            return string;
        }
    }

    private static String copyIntoZip(InputStream is, String targetFilename, ZipOutputStream zos, Set<String> dirEntries) throws IOException {
        int length;
        String[] dirs = targetFilename.replace("\\", "/").split("/");
        StringBuilder dirname = new StringBuilder();
        for (int i = 0; i < dirs.length - 1; ++i) {
            dirname.append(dirs[i]).append("/");
            String level = dirname.toString();
            if (dirEntries.contains(level)) continue;
            zos.putNextEntry(new ZipEntry(level));
            dirEntries.add(level);
        }
        zos.putNextEntry(new ZipEntry(targetFilename));
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) > 0) {
            zos.write(buffer, 0, length);
        }
        zos.closeEntry();
        is.close();
        return targetFilename;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ProductValidationResponseApi validateRemote(RemoteService svc, Path zipFile) {
        if (!Files.isRegularFile(zipFile, new LinkOption[0])) {
            throw new IllegalStateException("zip file is not a regular file");
        }
        try (InputStream is = Files.newInputStream(zipFile, new OpenOption[0]);){
            Response response;
            MultiPart mp;
            block16: {
                ProductValidationResponseApi productValidationResponseApi;
                mp = new MultiPart();
                try {
                    StreamDataBodyPart bp = new StreamDataBodyPart("file", is);
                    bp.setFilename("file.zip");
                    bp.setMediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE);
                    mp.bodyPart(bp);
                    WebTarget target = JerseyClientFactory.get(svc).getBaseTarget(new Object[0]).path("/public/v1/validation");
                    response = target.request().post(Entity.entity(mp, MediaType.MULTIPART_FORM_DATA_TYPE));
                    if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) break block16;
                    productValidationResponseApi = new ProductValidationResponseApi(Collections.singletonList(new ProductValidationIssueApi(ProductValidationIssueApi.ProductValidationSeverity.ERROR, "Cannot validate: " + response.getStatusInfo().getReasonPhrase())));
                }
                catch (Throwable throwable) {
                    try {
                        mp.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                mp.close();
                return productValidationResponseApi;
            }
            ProductValidationResponseApi productValidationResponseApi = response.readEntity(ProductValidationResponseApi.class);
            mp.close();
            return productValidationResponseApi;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot upload zip file", e);
        }
    }
}

