/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive;

import com.codahale.metrics.Timer;
import io.bdeploy.bhive.BHiveExecution;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.ManifestSpawnListener;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.objects.ManifestDatabase;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.objects.ObjectManager;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.audit.AuditRecord;
import io.bdeploy.common.audit.Auditor;
import io.bdeploy.common.audit.NullAuditor;
import io.bdeploy.common.metrics.Metrics;
import io.bdeploy.common.util.ExceptionHelper;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.common.util.RuntimeAssert;
import io.bdeploy.common.util.Threads;
import io.bdeploy.common.util.ZipHelper;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHive
implements AutoCloseable,
BHiveExecution {
    private static final Logger log = LoggerFactory.getLogger(BHive.class);
    private final URI uri;
    private final FileSystem zipFs;
    private final Path objTmp;
    private final Path markerTmp;
    private final BHiveTransactions transactions;
    private final ObjectDatabase objects;
    private final ManifestDatabase manifests;
    private final ActivityReporter reporter;
    private final Auditor auditor;
    private int parallelism = 4;
    private Predicate<String> lockContentValidator = null;
    private Supplier<String> lockContentSupplier = null;

    public BHive(URI uri, Auditor auditor, ActivityReporter reporter) {
        Path relRoot;
        this.uri = uri;
        if (ZipHelper.isZipUri(uri)) {
            try {
                if (!uri.getScheme().equals("jar")) {
                    uri = URI.create("jar:" + uri);
                }
                TreeMap<String, Object> env = new TreeMap<String, Object>();
                env.put("create", "true");
                env.put("useTempFile", Boolean.TRUE);
                this.zipFs = FileSystems.newFileSystem(uri, env);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot open or create ZIP BHive " + uri, e);
            }
            relRoot = this.zipFs.getPath("/", new String[0]);
        } else {
            relRoot = Paths.get(uri);
            this.zipFs = null;
        }
        Path objRoot = relRoot.resolve("objects");
        try {
            this.objTmp = this.zipFs == null ? relRoot.resolve("tmp") : Files.createTempDirectory("objdb-", new FileAttribute[0]);
            this.markerTmp = this.zipFs == null ? relRoot.resolve("markers") : this.objTmp.resolve("markers");
            PathHelper.mkdirs(this.markerTmp);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temporary directory for zipped BHive", e);
        }
        this.auditor = auditor == null ? new NullAuditor() : auditor;
        this.transactions = new BHiveTransactions(this, this.markerTmp, reporter);
        this.objects = new ObjectDatabase(objRoot, this.objTmp, reporter, this.transactions);
        this.manifests = new ManifestDatabase(relRoot.resolve("manifests"));
        this.reporter = reporter;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public void addSpawnListener(ManifestSpawnListener listener) {
        this.manifests.addSpawnListener(listener);
    }

    public void removeSpawnListener(ManifestSpawnListener listener) {
        this.manifests.removeSpawnListener(listener);
    }

    public void setLockContentSupplier(Supplier<String> lockContentSupplier) {
        this.lockContentSupplier = lockContentSupplier;
    }

    public void setLockContentValidator(Predicate<String> lockContentValidator) {
        this.lockContentValidator = lockContentValidator;
    }

    protected Supplier<String> getLockContentSupplier() {
        return this.lockContentSupplier;
    }

    protected Predicate<String> getLockContentValidator() {
        return this.lockContentValidator;
    }

    public <T> T execute(Operation<T> op) {
        try {
            op.initOperation(this);
            T t = this.doExecute(op, 0);
            return t;
        }
        finally {
            op.closeOperation();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <T> T doExecute(Operation<T> op, int attempt) {
        try (Timer.Context timer = Metrics.getMetric(Metrics.MetricGroup.HIVE).timer(op.getClass().getSimpleName()).time();){
            if (op.getClass().getAnnotation(ReadOnlyOperation.class) == null) {
                this.auditor.audit(AuditRecord.Builder.fromSystem().setWhat(op.getClass().getSimpleName()).addParameters(new AuditParameterExtractor().extract(op)).build());
            }
            Object v = op.call();
            return (T)v;
        }
        catch (Exception ex) {
            this.onOperationFailed(op, ex);
            if (attempt >= op.retryCount) {
                throw new IllegalStateException("Operation on hive " + op.hive + " failed", ex);
            }
            this.onOperationRetry(op, attempt, ex);
            return this.doExecute(op, ++attempt);
        }
    }

    private <T> void onOperationRetry(Operation<T> op, int attempt, Exception ex) {
        String retryString = attempt + 1 + " / " + op.retryCount;
        this.auditor.audit(AuditRecord.Builder.fromSystem().setWhat(op.getClass().getSimpleName()).setSeverity(AuditRecord.Severity.NORMAL).setMessage("Retrying operation due to previous failure. Attempt " + retryString).build());
        log.warn("Operation failed. Attempt {}", (Object)retryString, (Object)ex);
        try (ActivityReporter.Activity activity = this.reporter.start("Operation failed (" + retryString + "). Waiting before next retry...", attempt);){
            for (int sleep = 0; sleep <= attempt; ++sleep) {
                Threads.sleep(1000L);
                activity.worked(1L);
            }
        }
    }

    private <T> void onOperationFailed(Operation<T> op, Exception e) {
        this.auditor.audit(AuditRecord.Builder.fromSystem().setWhat(op.getClass().getSimpleName()).setSeverity(AuditRecord.Severity.ERROR).addParameters(new AuditParameterExtractor().extract(op)).setMessage(ExceptionHelper.mapExceptionCausesToReason(e)).build());
    }

    @Override
    public BHiveTransactions getTransactions() {
        return this.transactions;
    }

    @Override
    public void close() {
        if (this.zipFs != null) {
            try {
                this.zipFs.close();
            }
            catch (IOException e) {
                log.warn("Cannot close ZIP FS: {}", (Object)this.uri, (Object)e);
            }
            PathHelper.deleteRecursive(this.objTmp);
        }
        this.manifests.close();
        this.auditor.close();
    }

    public static abstract class Operation<T>
    implements Callable<T>,
    BHiveExecution {
        private BHive hive;
        private ObjectManager mgr;
        private ExecutorService fileOps;
        private static final AtomicInteger fileOpNum = new AtomicInteger(0);
        private int retryCount = 0;

        void initOperation(BHive hive) {
            this.hive = hive;
            this.fileOps = Executors.newFixedThreadPool(hive.parallelism, new NamedDaemonThreadFactory(() -> "File-OPS-" + fileOpNum.incrementAndGet()));
            this.mgr = new ObjectManager(hive.objects, hive.manifests, hive.reporter, this.fileOps);
        }

        private final void closeOperation() {
            this.fileOps.shutdownNow();
            this.hive = null;
            this.mgr = null;
        }

        protected ObjectManager getObjectManager() {
            return this.mgr;
        }

        protected ManifestDatabase getManifestDatabase() {
            return this.hive.manifests;
        }

        protected Path getMarkerRoot() {
            return this.hive.markerTmp;
        }

        protected ActivityReporter getActivityReporter() {
            return this.hive.reporter;
        }

        protected Auditor getAuditor() {
            return this.hive.auditor;
        }

        protected Predicate<String> getLockContentValidator() {
            return this.hive.lockContentValidator;
        }

        protected Supplier<String> getLockContentSupplier() {
            return this.hive.lockContentSupplier;
        }

        @Override
        public BHiveTransactions getTransactions() {
            return this.hive.getTransactions();
        }

        protected Future<?> submitFileOperation(Runnable op) {
            return this.fileOps.submit(op::run);
        }

        @Override
        public <X> X execute(Operation<X> other) {
            return this.hive.execute(other);
        }

        public Operation<T> setRetryCount(int retryCount) {
            RuntimeAssert.assertTrue(retryCount >= 0, "Counter must be >=0 but was " + retryCount);
            this.retryCount = retryCount;
            return this;
        }
    }

    public static abstract class TransactedOperation<T>
    extends Operation<T> {
        @Override
        public final T call() throws Exception {
            if (!super.getTransactions().hasTransaction()) {
                throw new IllegalStateException("Operation requires active transaction: " + this.getClass().getSimpleName());
            }
            return this.callTransacted();
        }

        protected abstract T callTransacted() throws Exception;
    }
}

