/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.MarkerDatabase;
import io.bdeploy.bhive.op.AwaitDirectoryLockOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.common.util.StringHelper;
import io.bdeploy.common.util.UuidHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHiveTransactions {
    private static final Logger log = LoggerFactory.getLogger(BHiveTransactions.class);
    private static final String TX_PID_FILE = "tx.pid";
    private final InheritableThreadLocal<Stack<String>> transactions = new InheritableThreadLocal();
    private final Map<String, MarkerDatabase> dbs = new ConcurrentHashMap<String, MarkerDatabase>();
    private final BHive hive;
    private final ActivityReporter reporter;
    private final Path markerRoot;

    public BHiveTransactions(BHive hive, Path markerRoot, ActivityReporter reporter) {
        this.hive = hive;
        this.markerRoot = markerRoot;
        this.reporter = reporter;
    }

    public void detachThread() {
        this.transactions.set(new Stack());
    }

    private Stack<String> getOrCreate() {
        Stack result = (Stack)this.transactions.get();
        if (result == null) {
            result = new Stack();
            this.transactions.set(result);
        }
        return result;
    }

    public void touchObject(ObjectId object) {
        String id;
        Stack all = (Stack)this.transactions.get();
        String string = id = all == null || all.isEmpty() ? null : (String)all.peek();
        if (id == null) {
            throw new IllegalStateException("No transaction active while inserting object.");
        }
        MarkerDatabase mdb = this.dbs.get(id);
        if (mdb == null) {
            throw new IllegalStateException("Transaction database missing for transaction " + id);
        }
        mdb.addMarker(object);
    }

    public boolean hasTransaction() {
        Stack stack = (Stack)this.transactions.get();
        return stack != null && !stack.isEmpty();
    }

    public Transaction begin() {
        this.hive.execute(new AwaitDirectoryLockOperation().setDirectory(this.markerRoot));
        String txid = UuidHelper.randomId();
        this.getOrCreate().push(txid);
        Path mdbPath = this.markerRoot.resolve(txid);
        this.dbs.put(txid, new MarkerDatabase(mdbPath, this.reporter));
        if (this.hive.getLockContentSupplier() != null) {
            String txValidationContent = this.hive.getLockContentSupplier().get();
            try {
                Files.write(mdbPath.resolve(TX_PID_FILE), Collections.singletonList(txValidationContent), new OpenOption[0]);
            }
            catch (IOException e) {
                log.debug("Cannot write transaction validation information", e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Starting transaction {}", (Object)txid, (Object)new RuntimeException("Starting Transaction"));
        }
        return () -> {
            this.hive.execute(new AwaitDirectoryLockOperation().setDirectory(this.markerRoot));
            Stack stack = (Stack)this.transactions.get();
            if (stack == null || stack.isEmpty()) {
                throw new IllegalStateException("No transaction has been started on this thread!");
            }
            String top = (String)stack.peek();
            if (!top.equals(txid)) {
                log.warn("Out-of-order transaction found: {}, expected: {}", (Object)top, (Object)txid);
            }
            if (log.isTraceEnabled()) {
                log.trace("Ending transaction {}", (Object)txid, (Object)new RuntimeException("Ending Transaction"));
            }
            stack.remove(txid);
            this.dbs.remove(txid);
            Path mdb = mdbPath;
            if (!Files.isDirectory(mdb, new LinkOption[0])) {
                return;
            }
            PathHelper.deleteRecursive(mdb);
        };
    }

    public long cleanStaleTransactions() {
        if (this.hive.getLockContentValidator() == null) {
            return 0L;
        }
        LongAdder amount = new LongAdder();
        try {
            Files.list(this.markerRoot).forEach(p -> {
                if (Files.isDirectory(p, new LinkOption[0]) && PathHelper.exists(p.resolve(TX_PID_FILE))) {
                    try {
                        List<String> lines = Files.readAllLines(p.resolve(TX_PID_FILE));
                        if (!(lines.isEmpty() || StringHelper.isNullOrEmpty(lines.get(0)) || this.hive.getLockContentValidator().test(lines.get(0)))) {
                            log.warn("Stale transaction detected, removing.");
                            PathHelper.deleteRecursive(p);
                            amount.increment();
                        }
                    }
                    catch (IOException e) {
                        log.warn("Problem determining stale transactions", e);
                    }
                }
            });
        }
        catch (IOException e) {
            log.warn("Cannot list potentially stale transaction databases", e);
        }
        return amount.sum();
    }

    public static interface Transaction
    extends AutoCloseable {
        @Override
        public void close();
    }
}

