/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.op.ObjectSizeOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.ToolDefaultVerbose;
import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.util.FormatHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;

@Configuration.Help(value="Calculate disc usage for given Manifest(s).")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="du")
@ToolDefaultVerbose(value=true)
public class DiscUsageTool
extends ToolBase.ConfiguredCliTool<DiscUsageConfig> {
    public DiscUsageTool() {
        super(DiscUsageConfig.class);
    }

    @Override
    protected RenderableResult run(DiscUsageConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        if (config.manifestPrefix() != null && config.manifest().length != 0) {
            this.helpAndFail("Pass either prefix or manifests, not both");
        }
        Path path = Paths.get(config.hive(), new String[0]);
        DataTable result = this.createDataTable();
        result.setCaption("Disc Usage");
        result.column("Manifest Name", 100).column("Tag", 20).column("Size", 15).column("# Obj", 10).column("# Ref", 5);
        result.addFooter("Note that objects may be calculated multiple times. The actual disc usage sum may be much lower than the sum of manifest size.");
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), new ActivityReporter.Null());){
            TreeSet<Manifest.Key> keys = new TreeSet<Manifest.Key>();
            if (config.manifestPrefix() != null) {
                keys.addAll((Collection)hive.execute(new ManifestListOperation().setManifestName(config.manifestPrefix())));
            } else if (config.manifest().length > 0) {
                for (String k : config.manifest()) {
                    keys.add(Manifest.Key.parse(k));
                }
            } else {
                keys.addAll((Collection)hive.execute(new ManifestListOperation()));
            }
            try (ActivityReporter.Activity calculating = this.getActivityReporter().start("Calculate Disc Usage", keys.size());){
                for (Manifest.Key k : keys) {
                    this.calculateUsage(hive, k, result);
                    calculating.worked(1L);
                }
            }
        }
        return result;
    }

    private void calculateUsage(BHive hive, Manifest.Key key, DataTable result) {
        LongAdder refs = new LongAdder();
        Set<ObjectId> objects = hive.execute(new ObjectListOperation().addManifest(key));
        Long size = hive.execute(new ObjectSizeOperation().addObject(objects));
        result.row().cell(key.getName()).cell(key.getTag()).cell(FormatHelper.formatFileSize(size)).cell(objects.size()).cell(refs.sum()).build();
    }

    public static @interface DiscUsageConfig {
        @Configuration.Help(value="The local BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="Manifest(s) to inspect. May appear multiple times. Format is 'name:tag'. If not present, all manifests are calculated.")
        public String[] manifest() default {};

        @Configuration.Help(value="Manifest name prefix. All manifests matching this prefix will be calculated.")
        public String manifestPrefix();
    }
}

