/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.ExportOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.NonExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.RenderableResult;
import java.nio.file.Path;
import java.nio.file.Paths;

@Configuration.Help(value="Export a given manifest to a given target location")
@ToolCategory(value="Filesystem interaction commands")
@ToolBase.CliTool.CliName(value="export")
public class ExportTool
extends ToolBase.ConfiguredCliTool<ExportConfig> {
    public ExportTool() {
        super(ExportConfig.class);
    }

    @Override
    protected RenderableResult run(ExportConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        this.helpAndFailIfMissing(config.manifest(), "Missing --manifest");
        Path targetPath = Paths.get(config.target(), new String[0]);
        Path path = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), this.getActivityReporter());){
            hive.setParallelism(config.jobs());
            ExportOperation export = new ExportOperation().setManifest(Manifest.Key.parse(config.manifest())).setTarget(targetPath);
            hive.execute(export);
        }
        return this.createSuccess();
    }

    public static @interface ExportConfig {
        @Configuration.Help(value="The source BHive to export from")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="The target path to export to")
        @Configuration.Validator(value={NonExistingPathValidator.class})
        public String target();

        @Configuration.Help(value="Manifest(s) to export. Format is 'name:tag'")
        public String manifest();

        @Configuration.Help(value="Parallelism - how many threads to use to export. Default: 4")
        public int jobs() default 4;
    }
}

