/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.remote.FetchOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.ToolDefaultVerbose;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.jersey.cli.RemoteServiceTool;
import java.nio.file.Path;
import java.nio.file.Paths;

@Configuration.Help(value="Fetch Manifest(s) from a remote BHive instance.")
@ToolCategory(value="Remote server interaction commands")
@ToolBase.CliTool.CliName(value="fetch")
@ToolDefaultVerbose(value=true)
public class FetchTool
extends RemoteServiceTool<FetchConfig> {
    public FetchTool() {
        super(FetchConfig.class);
    }

    @Override
    protected RenderableResult run(FetchConfig config, RemoteService svc) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        Path path = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), this.getActivityReporter());){
            BHiveTransactions.Transaction t = hive.getTransactions().begin();
            try {
                FetchOperation op = ((FetchOperation)new FetchOperation().setRemote(svc)).setHiveName(config.source());
                for (String m3 : config.manifest()) {
                    Manifest.Key key = Manifest.Key.parse(m3);
                    op.addManifest(key);
                }
                TransferStatistics stats = hive.execute(op);
                DataResult dataResult = stats.toResult(this.createSuccess());
                if (t != null) {
                    t.close();
                }
                return dataResult;
            }
            catch (Throwable throwable) {
                if (t != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public static @interface FetchConfig {
        @Configuration.Help(value="The local BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="The remote hive name if not default")
        @Configuration.EnvironmentFallback(value="REMOTE_BHIVE")
        public String source();

        @Configuration.Help(value="Manifest(s) to push. May appear multiple times. Format is 'name:tag'")
        public String[] manifest() default {};
    }
}

