/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.view.DamagedObjectView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.op.FsckOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.RenderableResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;

@Configuration.Help(value="Check manifest and object consistency on a BHive instance. Broken objects will be removed.")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="fsck")
public class FsckTool
extends ToolBase.ConfiguredCliTool<FsckConfig> {
    public FsckTool() {
        super(FsckConfig.class);
    }

    @Override
    protected RenderableResult run(FsckConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        Path path = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), this.getActivityReporter());){
            FsckOperation op = new FsckOperation().setRepair(config.repair());
            Arrays.stream(config.manifest()).map(Manifest.Key::parse).forEach(op::addManifest);
            Set<ElementView> broken = hive.execute(op);
            if (broken.isEmpty()) {
                DataResult dataResult = this.createSuccess();
                return dataResult;
            }
            DataResult result = this.createResultWithSuccessMessage("Found " + broken.size() + " damaged objects!");
            for (ElementView ele : broken) {
                result.addField(ele.getElementId().toString(), (String)(ele instanceof DamagedObjectView ? ((DamagedObjectView)ele).getType() + " " : "") + ele.getPathString());
            }
            DataResult dataResult = result;
            return dataResult;
        }
    }

    public static @interface FsckConfig {
        @Configuration.Help(value="The local BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="Manifest(s) to check. May appear multiple times. Format is 'name:tag'. If not present, all manifests are checked.")
        public String[] manifest() default {};

        @Configuration.Help(value="Repair the Hive by removing any damaged objects", arg=false)
        public boolean repair() default false;
    }
}

