/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.common.audit.AuditRecord;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.NonExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.RenderableResult;
import java.nio.file.Path;
import java.nio.file.Paths;

@Configuration.Help(value="Initializes an empty BHive")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="init")
public class InitTool
extends ToolBase.ConfiguredCliTool<InitConfig> {
    public InitTool() {
        super(InitConfig.class);
    }

    @Override
    protected RenderableResult run(InitConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        Path root = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(root.toUri(), this.getAuditorFactory().apply(root), this.getActivityReporter());){
            hive.getAuditor().audit(AuditRecord.Builder.fromSystem().addParameters(this.getRawConfiguration()).setWhat("init").build());
        }
        return this.createSuccess();
    }

    public static @interface InitConfig {
        @Configuration.Help(value="The directory to initialize as BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={NonExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();
    }
}

