/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.DataTable;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.FormatHelper;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.jersey.cli.RemoteServiceTool;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.SortedMap;

@Configuration.Help(value="Query and manipulate manifests in the given BHive")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="manifest")
public class ManifestTool
extends RemoteServiceTool<ManifestConfig> {
    public ManifestTool() {
        super(ManifestConfig.class);
    }

    @Override
    protected RenderableResult run(ManifestConfig config, @RemoteServiceTool.RemoteOptional RemoteService svc) {
        if (svc == null) {
            this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        }
        if (!config.list() && !config.delete() && config.saveTo() == null) {
            return this.createNoOp();
        }
        if (config.hive() != null) {
            return this.runOnLocalHive(config);
        }
        return this.runOnRemoteHive(config, svc);
    }

    private RenderableResult runOnRemoteHive(ManifestConfig config, RemoteService svc) {
        if (config.delete()) {
            throw new UnsupportedOperationException("Remote manifest deletion not supported.");
        }
        if (config.saveTo() != null) {
            throw new UnsupportedOperationException("Remote manifest saving not supported.");
        }
        try (RemoteBHive rh = RemoteBHive.forService(svc, config.source(), this.getActivityReporter());){
            if (config.list()) {
                SortedMap<Manifest.Key, ObjectId> mfs = rh.getManifestInventory(new String[0]);
                if (mfs.isEmpty()) {
                    DataResult dataResult = this.createResultWithErrorMessage("No manifests found");
                    return dataResult;
                }
                DataTable table = this.createDataTable();
                table.column("Key", 50).column("Root", 40);
                mfs.entrySet().stream().filter(e -> this.matches((Manifest.Key)e.getKey(), config)).forEach(e -> table.row().cell(e.getKey()).cell(e.getValue()).build());
                DataTable dataTable = table;
                return dataTable;
            }
        }
        return this.createSuccess();
    }

    private RenderableResult runOnLocalHive(ManifestConfig config) {
        Path path = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), this.getActivityReporter());){
            if (config.list()) {
                Set<Manifest.Key> manifests = hive.execute(new ManifestListOperation());
                if (manifests.isEmpty()) {
                    DataResult dataResult = this.createResultWithErrorMessage("No manifests found");
                    return dataResult;
                }
                DataTable table = this.createDataTable();
                table.column("Key", 50).column("Root", 40);
                manifests.stream().filter(x -> this.matches((Manifest.Key)x, config)).forEach(e -> {
                    Manifest m3 = hive.execute(new ManifestLoadOperation().setManifest((Manifest.Key)e));
                    table.row().cell(e).cell(m3.getRoot().toString()).build();
                });
                DataTable dataTable = table;
                return dataTable;
            }
            if (config.delete()) {
                this.helpAndFailIfMissing(config.manifest(), "Missing --manifest");
                Manifest.Key manifest = Manifest.Key.parse(config.manifest());
                hive.execute(new ManifestDeleteOperation().setToDelete(manifest));
                DataResult dataResult = this.createSuccess().addField("Deleted", manifest.toString());
                return dataResult;
            }
            if (config.saveTo() != null) {
                DataResult dataResult = this.doSaveTo(config, hive);
                return dataResult;
            }
            DataResult dataResult = this.createSuccess();
            return dataResult;
        }
    }

    private DataResult doSaveTo(ManifestConfig config, BHive hive) {
        this.helpAndFailIfMissing(config.manifest(), "Missing --manifest");
        Manifest.Key manifest = Manifest.Key.parse(config.manifest());
        Path tmpFile = null;
        try {
            tmpFile = Files.createTempDirectory("bdeploy-", new FileAttribute[0]);
            Set<ObjectId> objectIds = hive.execute(new ObjectListOperation().addManifest(manifest));
            URI targetUri = UriBuilder.fromUri("jar:" + Paths.get(config.saveTo(), new String[0]).toUri()).build(new Object[0]);
            BHive zipHive = new BHive(targetUri, null, new ActivityReporter.Null());
            try {
                CopyOperation op = new CopyOperation().setDestinationHive(zipHive);
                op.addManifest(manifest);
                objectIds.forEach(op::addObject);
                TransferStatistics stats = hive.execute(op);
                DataResult result = this.createSuccess();
                result.addField("Number of Manifests", stats.sumManifests);
                result.addField("Number of Objects", stats.sumMissingObjects);
                result.addField("Duration", FormatHelper.formatDuration(stats.duration));
                DataResult dataResult = result;
                zipHive.close();
                return dataResult;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        zipHive.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to save manifest", ex);
                }
            }
        }
        finally {
            if (tmpFile != null) {
                PathHelper.deleteRecursive(tmpFile);
            }
        }
    }

    private boolean matches(Manifest.Key x, ManifestConfig config) {
        if (config.manifest().isEmpty()) {
            return true;
        }
        if (!config.manifest().contains(":") && !x.getName().equals(config.manifest())) {
            return false;
        }
        return Manifest.Key.parse(config.manifest()).equals(x);
    }

    public static @interface ManifestConfig {
        @Configuration.Help(value="The BHive to use. Alternatively use --remote.")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="List available manifests", arg=false)
        public boolean list() default false;

        @Configuration.Help(value="Delete a given manifest", arg=false)
        public boolean delete() default false;

        @Configuration.Help(value="The name of the hive on the remote server if going remote")
        public String source();

        @Configuration.Help(value="Manifest(s) to manipulate/list. Format is 'name:tag'. Name without tag is supported to list tags of a given name.")
        public String manifest() default "";

        @Configuration.Help(value="Path to a ZIP file where the manifest and all its dependencies should be saved to.")
        public String saveTo();
    }
}

