/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.PruneOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.util.FormatHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.SortedMap;
import java.util.stream.Collectors;

@Configuration.Help(value="Prune any unreferenced objects from the given BHive")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="prune")
public class PruneTool
extends ToolBase.ConfiguredCliTool<PruneConfig> {
    public PruneTool() {
        super(PruneConfig.class);
    }

    @Override
    protected RenderableResult run(PruneConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        Path path = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), this.getActivityReporter());){
            SortedMap<ObjectId, Long> result = hive.execute(new PruneOperation());
            DataResult r = this.createSuccess();
            if (config.verbose()) {
                result.forEach((k, v) -> r.addField(k.toString(), FormatHelper.formatFileSize(v)));
            }
            long sum = result.values().stream().collect(Collectors.summarizingLong(x -> x)).getSum();
            r.addField("Sum Objects Removed", Integer.toString(result.size()));
            r.addField("Sum Bytes Freed", FormatHelper.formatFileSize(sum));
            DataResult dataResult = r;
            return dataResult;
        }
    }

    public static @interface PruneConfig {
        @Configuration.Help(value="The BHive to use")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="List details about removed objects", arg=false)
        public boolean verbose() default false;
    }
}

