/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.remote.jersey.BHiveJacksonModule;
import io.bdeploy.bhive.remote.jersey.BHiveLocatorImpl;
import io.bdeploy.bhive.remote.jersey.BHiveRegistry;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.security.SecurityHelper;
import io.bdeploy.jersey.JerseyServer;
import io.bdeploy.jersey.ws.change.ObjectChangeBroadcaster;
import io.bdeploy.jersey.ws.change.ObjectChangeWebSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

@Configuration.Help(value="Serve given BHives over the network.")
@ToolCategory(value="Server commands")
@ToolBase.CliTool.CliName(value="serve")
public class ServeTool
extends ToolBase.ConfiguredCliTool<ServeConfig> {
    public ServeTool() {
        super(ServeConfig.class);
    }

    @Override
    protected RenderableResult run(ServeConfig config) {
        this.helpAndFailIfMissing(config.serve(), "Missing --serve");
        this.helpAndFailIfMissing(config.keystore(), "Missing --keystore");
        TreeMap<String, BHive> hives = new TreeMap<String, BHive>();
        try {
            for (String s2 : config.serve()) {
                int index = s2.indexOf(58);
                String path = s2.substring(0, index);
                String hive = s2.substring(index + 1);
                Path hPath = Paths.get(hive, new String[0]);
                if (!Files.isDirectory(hPath, new LinkOption[0])) {
                    this.out().println("WARNING: Skipping non-existant: " + hPath);
                    continue;
                }
                hives.put(path, new BHive(hPath.toUri(), this.getAuditorFactory().apply(hPath), this.getActivityReporter()));
            }
            Path storePath = Paths.get(config.keystore(), new String[0]);
            char[] passphrase = config.passphrase() == null ? null : config.passphrase().toCharArray();
            KeyStore ks = SecurityHelper.getInstance().loadPrivateKeyStore(storePath, passphrase);
            this.out().println("Serving " + hives.size() + " hive" + (hives.size() == 1 ? "" : "s") + " on port " + config.port());
            this.runServer(config.port(), hives, ks, passphrase);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while preparing or running server", e);
        }
        finally {
            hives.forEach((k, v) -> v.close());
        }
        return null;
    }

    private void runServer(short port, Map<String, BHive> hives, KeyStore ks, char[] passphrase) {
        try (JerseyServer server = new JerseyServer(port, ks, passphrase);){
            BHiveRegistry reg = new BHiveRegistry(this.getActivityReporter(), null);
            for (Map.Entry<String, BHive> entry : hives.entrySet()) {
                reg.register(entry.getKey(), entry.getValue());
            }
            final ObjectChangeWebSocket ocws = new ObjectChangeWebSocket(server.getKeyStore());
            server.registerWebsocketApplication("/object-changes", ocws);
            server.registerResource(reg);
            server.register(reg.binder());
            server.register(new BHiveJacksonModule().binder());
            server.register(BHiveLocatorImpl.class);
            server.register(new AbstractBinder(){

                @Override
                protected void configure() {
                    this.bind(ocws).to(ObjectChangeBroadcaster.class);
                }
            });
            server.start();
            server.join();
        }
    }

    public static @interface ServeConfig {
        @Configuration.Help(value="Mapping from context path to BHive directory, ':' separated. E.g. 'myhive:/path/to/hive' will serve on 'https://host:port/api/hives/myhive'")
        public String[] serve();

        @Configuration.Help(value="Private KeyStore containing the server certificate and private key")
        @Configuration.Validator(value={ExistingPathValidator.class})
        public String keystore();

        @Configuration.Help(value="Passphrase for the private KeyStore")
        public String passphrase();

        @Configuration.Help(value="Port to serve on")
        public short port() default 7700;
    }
}

