/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.security.ApiAccessToken;
import io.bdeploy.common.security.SecurityHelper;
import io.bdeploy.common.util.PathHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;

@Configuration.Help(value="Generate, import and verify access tokens.")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="token")
public class TokenTool
extends ToolBase.ConfiguredCliTool<TokenConfig> {
    public TokenTool() {
        super(TokenConfig.class);
    }

    @Override
    protected RenderableResult run(TokenConfig config) {
        char[] pass;
        this.helpAndFailIfMissing(config.keystore(), "Missing --keystore");
        Path ksPath = Paths.get(config.keystore(), new String[0]);
        char[] cArray = pass = config.passphrase() == null ? null : config.passphrase().toCharArray();
        if (config.create()) {
            return this.createNewToken(ksPath, pass);
        }
        if (config.load()) {
            this.helpAndFailIfMissing(config.pack(), "Missing --pack");
            this.importExistingToken(ksPath, pass, config.pack());
            return this.createSuccess();
        }
        if (config.check()) {
            this.helpAndFailIfMissing(config.token(), "Missing --token");
            return this.checkExistingToken(ksPath, pass, config.token());
        }
        if (config.dump()) {
            this.dumpExistingToken(ksPath, pass);
            return null;
        }
        return this.createNoOp();
    }

    private void dumpExistingToken(Path ksPath, char[] pass) {
        SecurityHelper helper = SecurityHelper.getInstance();
        try {
            KeyStore ks = helper.loadPublicKeyStore(ksPath, pass);
            this.out().println(helper.getSignedToken(ks, pass));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load access token from " + ksPath, e);
        }
    }

    private DataResult createNewToken(Path keystore, char[] passphrase) {
        SecurityHelper helper = SecurityHelper.getInstance();
        ApiAccessToken aat = new ApiAccessToken.Builder().forSystem().addPermission(ApiAccessToken.ADMIN_PERMISSION).build();
        try {
            String pack = helper.createSignaturePack(aat, keystore, passphrase);
            this.out().println(pack);
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot create signature pack", e);
        }
        return this.createSuccess().addField("Valid For", "50 years").addField("Issued To", aat.getIssuedTo()).addField("Permissions", aat.getPermissions().toString());
    }

    private void importExistingToken(Path keystore, char[] passphrase, String sigPack) {
        SecurityHelper helper = SecurityHelper.getInstance();
        try {
            helper.importSignaturePack(sigPack, keystore, passphrase);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot import signature pack", e);
        }
    }

    private DataResult checkExistingToken(Path keystore, char[] passphrase, String token) {
        this.checkPrivateKeyStoreExists(keystore);
        SecurityHelper helper = SecurityHelper.getInstance();
        try {
            KeyStore ks = helper.loadPrivateKeyStore(keystore, passphrase);
            ApiAccessToken pl = helper.getVerifiedPayload(token, ApiAccessToken.class, ks);
            if (pl == null) {
                return this.createResultWithErrorMessage("Invalid signature.");
            }
            if (!pl.isValid()) {
                return this.createResultWithErrorMessage("Signature valid, but token expired");
            }
            return this.createResultWithSuccessMessage("Signature valid. Issued to " + pl.getIssuedTo() + ".");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot verify token", e);
        }
    }

    private void checkPrivateKeyStoreExists(Path keystore) {
        if (!PathHelper.exists(keystore)) {
            this.out().println("You must generate a keystore manually: ");
            this.out().println("  openssl req -newkey rsa:2048 -nodes -keyout key.pem -x509 -days 17800 -out cert.pem");
            this.out().println("  openssl pkcs12 -inkey key.pem  -in cert.pem -export -out certstore.p12");
            throw new IllegalArgumentException("private keystore does not exist: " + keystore);
        }
    }

    public static @interface TokenConfig {
        @Configuration.Help(value="Path to the (PKCS12) private or (JKS) public key store, depending on other parameters")
        public String keystore();

        @Configuration.Help(value="Passphrase for the keystore and any contained keys")
        public String passphrase();

        @Configuration.Help(value="Create a token from the private key in the given keystore", arg=false)
        public boolean create() default false;

        @Configuration.Help(value="Load a public key and token and store into the given truststore", arg=false)
        public boolean load() default false;

        @Configuration.Help(value="The signature pack of the remote to load into the truststore")
        public String pack();

        @Configuration.Help(value="Validate a given token against the given private key store", arg=false)
        public boolean check() default false;

        @Configuration.Help(value="Dump the current access token in the given truststore", arg=false)
        public boolean dump() default false;

        @Configuration.Help(value="The signed token value to check agains the private key store")
        public String token();
    }
}

