/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeDiff;
import io.bdeploy.bhive.objects.view.scanner.TreeElementDiff;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ObjectSizeOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cfg.PathOwnershipValidator;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolCategory;
import io.bdeploy.common.cli.data.DataResult;
import io.bdeploy.common.cli.data.RenderableResult;
import io.bdeploy.common.util.FormatHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.IntStream;

@Configuration.Help(value="Query and diff manifest root trees in the given BHive")
@ToolCategory(value="Analysis and maintenance commands")
@ToolBase.CliTool.CliName(value="tree")
public class TreeTool
extends ToolBase.ConfiguredCliTool<TreeConfig> {
    private static final String EMPTY_ID = "0000000000000000000000000000000000000000";

    public TreeTool() {
        super(TreeConfig.class);
    }

    @Override
    protected RenderableResult run(TreeConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        Path path = Paths.get(config.hive(), new String[0]);
        try (BHive hive = new BHive(path.toUri(), this.getAuditorFactory().apply(path), this.getActivityReporter());){
            if (config.list() != null) {
                TreeView snap = hive.execute(new ScanOperation().setManifest(Manifest.Key.parse(config.list())));
                this.format(snap);
                DataResult dataResult = this.createSuccess();
                return dataResult;
            }
            if (config.diff().length > 0) {
                if (config.diff().length != 2) {
                    this.helpAndFail("Currently only support diff of two manifests");
                }
                TreeView t1 = hive.execute(new ScanOperation().setManifest(Manifest.Key.parse(config.diff()[0])));
                TreeView t2 = hive.execute(new ScanOperation().setManifest(Manifest.Key.parse(config.diff()[1])));
                DataResult dataResult = this.format(new TreeDiff(t1, t2).diff(), t1, hive);
                return dataResult;
            }
            DataResult dataResult = this.createNoOp();
            return dataResult;
        }
    }

    private DataResult format(List<TreeElementDiff> diff, TreeView original, BHive hive) {
        for (TreeElementDiff ted : diff) {
            switch (ted.getType()) {
                case CONTENT_DIFF: {
                    this.out().println("C: [" + ted.getLeftType().name().charAt(0) + "]" + ted.getLeft().getElementId() + " : [" + ted.getRightType().name().charAt(0) + "]" + ted.getRight().getElementId() + " " + ted.getLeft().getPathString());
                    break;
                }
                case ONLY_LEFT: {
                    this.out().println("L: [" + ted.getLeftType().name().charAt(0) + "]" + ted.getLeft().getElementId() + " : [ ]0000000000000000000000000000000000000000 " + ted.getLeft().getPathString());
                    break;
                }
                case ONLY_RIGHT: {
                    this.out().println("R: [ ]0000000000000000000000000000000000000000 : [" + ted.getRightType().name().charAt(0) + "]" + ted.getRight().getElementId() + " " + ted.getRight().getPathString());
                }
            }
        }
        TreeSet existingObjs = new TreeSet();
        Function<ElementView, Boolean> enlist = ev -> {
            existingObjs.add(ev.getElementId());
            return true;
        };
        original.visit(new TreeVisitor.Builder().onBlob(enlist::apply).onTree(enlist::apply).onManifestRef(enlist::apply).build());
        ObjectSizeOperation oso = new ObjectSizeOperation();
        diff.stream().filter(d -> d.getType() != TreeElementDiff.DifferenceType.ONLY_LEFT).map(d -> d.getRight().getElementId()).filter(o -> !existingObjs.contains(o)).forEach(oso::addObject);
        Long size = hive.execute(oso);
        return this.createSuccess().addField("Difference Size", FormatHelper.formatFileSize(size));
    }

    private void format(TreeView snap) {
        snap.visit(new TreeVisitor.Builder().onBlob(b -> {
            this.indent((ElementView)b);
            this.out().println("[B] " + this.verbose((ElementView)b));
        }).onTree(t -> {
            this.indent((ElementView)t);
            this.out().println("[T] " + this.verbose((ElementView)t) + (String)(t instanceof ManifestRefView ? " {R:" + ((ManifestRefView)t).getReferenced() + "}" : ""));
            return true;
        }).onMissing(m3 -> {
            this.indent((ElementView)m3);
            this.out().println("[X] " + this.verbose((ElementView)m3) + " {MISSING}");
        }).build());
    }

    private String verbose(ElementView x) {
        StringBuilder builder = new StringBuilder();
        builder.append(x.getName());
        if (this.isVerbose()) {
            IntStream.range(0, Math.max(1, 80 - x.getPath().size() * 2 - x.getName().length())).forEach(i -> builder.append(' '));
            builder.append(x.getElementId());
        }
        return builder.toString();
    }

    private void indent(ElementView e) {
        e.getPath().forEach(x -> this.out().print("  "));
    }

    public static @interface TreeConfig {
        @Configuration.Help(value="The BHive to use. Alternatively use --remote.")
        @Configuration.EnvironmentFallback(value="BHIVE")
        @Configuration.Validator(value={ExistingPathValidator.class, PathOwnershipValidator.class})
        public String hive();

        @Configuration.Help(value="List content of given manifest")
        public String list();

        @Configuration.Help(value="Give two manifests to diff.")
        public String[] diff() default {};
    }
}

