/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.meta;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.op.ImportObjectOperation;
import io.bdeploy.bhive.op.InsertArtificialTreeOperation;
import io.bdeploy.bhive.op.InsertManifestOperation;
import io.bdeploy.bhive.op.ManifestDeleteOldByIdOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ManifestMaxIdOperation;
import io.bdeploy.bhive.op.TreeEntryLoadOperation;
import io.bdeploy.bhive.util.StorageHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentManifestClassification<T> {
    private static final String CLASSIFICATION_PREFIX = ".classification/";
    private static final String CLASSIFICATION_FILE = "classification";
    private static final Logger log = LoggerFactory.getLogger(PersistentManifestClassification.class);
    private final String classificationName;
    private final Function<Manifest, T> classifier;
    private final BHive hive;
    private static final Map<String, Object> loadLocks = new TreeMap<String, Object>();
    private SortedMap<Manifest.Key, T> classifications;

    public PersistentManifestClassification(BHive hive, String name, Function<Manifest, T> classifier) {
        this.classificationName = ".classification/persistent/" + name;
        this.classifier = classifier;
        this.hive = hive;
        loadLocks.computeIfAbsent(this.classificationName, k -> new Object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndUpdate(Set<Manifest.Key> keys) {
        Object object = loadLocks.get(this.classificationName);
        synchronized (object) {
            boolean modified;
            block17: {
                Optional<Long> id = this.hive.execute(new ManifestMaxIdOperation().setManifestName(this.classificationName));
                if (!id.isPresent()) {
                    this.classifications = new TreeMap<Manifest.Key, T>();
                } else {
                    Manifest.Key key = new Manifest.Key(this.classificationName, id.get().toString());
                    Manifest mf = this.hive.execute(new ManifestLoadOperation().setManifest(key));
                    try (InputStream is = this.hive.execute(new TreeEntryLoadOperation().setRootTree(mf.getRoot()).setRelativePath(CLASSIFICATION_FILE));){
                        this.classifications = StorageHelper.fromStream((InputStream)is, CfStorage.class).storage;
                    }
                    catch (Exception e2) {
                        log.debug("Cannot read {} for {}", CLASSIFICATION_FILE, key, e2);
                        this.classifications = new TreeMap<Manifest.Key, T>();
                    }
                }
                modified = false;
                Set filtered = keys.stream().filter(k -> !k.getName().startsWith(CLASSIFICATION_PREFIX)).collect(Collectors.toSet());
                long sz = this.classifications.size();
                this.classifications = this.classifications.entrySet().stream().filter(e -> filtered.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, TreeMap::new));
                modified = (long)this.classifications.size() != sz;
                sz = this.classifications.size();
                try {
                    filtered.stream().filter(k -> !this.classifications.containsKey(k)).map(k -> this.hive.execute(new ManifestLoadOperation().setManifest((Manifest.Key)k))).forEach(m3 -> {
                        T classification = this.classifier.apply((Manifest)m3);
                        if (classification != null) {
                            this.classifications.put(m3.getKey(), classification);
                        }
                    });
                    modified = (long)this.classifications.size() != sz;
                }
                catch (IllegalStateException ise) {
                    if (!log.isDebugEnabled()) break block17;
                    log.debug("Manifest cannot be loaded while classification", ise);
                }
            }
            if (modified) {
                this.store();
            }
        }
    }

    private void store() {
        String targetTag = "1";
        Optional<Long> id = this.hive.execute(new ManifestMaxIdOperation().setManifestName(this.classificationName));
        if (id.isPresent()) {
            targetTag = Long.toString(id.get() + 1L);
        }
        Manifest.Key targetKey = new Manifest.Key(this.classificationName, targetTag);
        Manifest.Builder newMf = new Manifest.Builder(targetKey);
        Tree.Builder newTree = new Tree.Builder();
        try (BHiveTransactions.Transaction tx = this.hive.getTransactions().begin();){
            CfStorage storage = new CfStorage();
            storage.storage = this.classifications;
            ObjectId oid = this.hive.execute(new ImportObjectOperation().setData(StorageHelper.toRawBytes(storage)));
            newTree.add(new Tree.Key(CLASSIFICATION_FILE, Tree.EntryType.BLOB), oid);
            ObjectId newTreeId = this.hive.execute(new InsertArtificialTreeOperation().setTree(newTree));
            this.hive.execute(new InsertManifestOperation().addManifest(newMf.setRoot(newTreeId).build(this.hive)));
        }
        this.hive.execute(new ManifestDeleteOldByIdOperation().setAmountToKeep(2).setToDelete(this.classificationName));
    }

    public SortedMap<Manifest.Key, T> getClassifications() {
        return this.classifications;
    }

    private static final class CfStorage<T> {
        @JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, property="@class", use=JsonTypeInfo.Id.CLASS)
        public SortedMap<Manifest.Key, T> storage;

        private CfStorage() {
        }
    }
}

