/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.bdeploy.bhive.BHiveExecution;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.MissingObjectView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ScanOperation;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Manifest
implements Serializable,
Comparable<Manifest> {
    private static final long serialVersionUID = 1L;
    private final Key key;
    private final ObjectId root;
    private final SortedMap<String, String> labels;
    private final SortedSet<ReferenceKey> references;

    @JsonCreator
    private Manifest(@JsonProperty(value="key") Key key, @JsonProperty(value="root") ObjectId root, @JsonProperty(value="labels") SortedMap<String, String> labels, @JsonProperty(value="references") SortedSet<ReferenceKey> references) {
        this.key = key;
        this.root = root;
        this.labels = labels;
        this.references = references;
    }

    public Key getKey() {
        return this.key;
    }

    public ObjectId getRoot() {
        return this.root;
    }

    public Map<String, String> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    SortedSet<ReferenceKey> internalGetCachedReferences() {
        return this.references;
    }

    public SortedMap<String, Key> getCachedReferences(BHiveExecution hive, int depth, boolean allowMissing) {
        if (this.references == null) {
            return null;
        }
        TreeMap<String, Key> result = new TreeMap<String, Key>();
        for (ReferenceKey rk : this.references) {
            Boolean exists;
            if (rk.depth > (long)depth) continue;
            if (!allowMissing && !Boolean.TRUE.equals(exists = hive.execute(new ManifestExistsOperation().setManifest(rk.key)))) {
                throw new IllegalStateException("Missing referenced manifest: " + rk.key + ", referenced from " + this.key + " [" + rk.path + "]");
            }
            result.put(rk.path, rk.key);
        }
        return result;
    }

    @Override
    public int compareTo(Manifest o) {
        return this.key.compareTo(o.key);
    }

    public String toString() {
        return "Manifest(" + this.root + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Manifest other = (Manifest)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    public static final class Key
    implements Serializable,
    Comparable<Key> {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String tag;

        @JsonCreator
        public Key(@JsonProperty(value="name") String name, @JsonProperty(value="tag") String tag) {
            this.name = name;
            this.tag = tag;
            if (name.contains(":") || tag.contains(":")) {
                throw new IllegalArgumentException("Manifest key may not contain the ':' character: " + name + " / " + tag);
            }
            if (name.contains("\\")) {
                throw new IllegalArgumentException("Manifest key may not contain the '\\' character: " + name + " / " + tag);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getTag() {
            return this.tag;
        }

        public String directoryFriendlyName() {
            return this.name.replace('/', '-') + "_" + this.tag;
        }

        @Override
        public int compareTo(Key o) {
            int x = this.name.compareTo(o.name);
            if (x != 0) {
                return x;
            }
            return this.tag.compareTo(o.tag);
        }

        public String toString() {
            return this.name + ":" + this.tag;
        }

        public static Key parse(String key) {
            int indexOf = key.indexOf(58);
            if (indexOf < 0) {
                throw new IllegalArgumentException("invalid manifest key format: " + key);
            }
            return new Key(key.substring(0, indexOf), key.substring(indexOf + 1));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }

    public static class ReferenceKey
    implements Serializable,
    Comparable<ReferenceKey> {
        private static final long serialVersionUID = 1L;
        private final String path;
        private final Key key;
        private final long depth;

        @JsonCreator
        public ReferenceKey(@JsonProperty(value="path") String path, @JsonProperty(value="key") Key key, @JsonProperty(value="depth") long depth) {
            this.path = path;
            this.key = key;
            this.depth = depth;
        }

        public long getDepth() {
            return this.depth;
        }

        public String getPath() {
            return this.path;
        }

        public Key getKey() {
            return this.key;
        }

        @Override
        public int compareTo(ReferenceKey o) {
            return this.path.compareTo(o.path);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceKey other = (ReferenceKey)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }

    public static final class Builder {
        private final Key key;
        private ObjectId root;
        private final SortedMap<String, String> labels = new TreeMap<String, String>();

        public Builder(Key key) {
            this.key = key;
        }

        public Builder setRoot(ObjectId root) {
            this.root = root;
            return this;
        }

        public Builder addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        public Manifest build(BHiveExecution hive) {
            return new Manifest(this.key, this.root, this.labels, this.findReferences(hive));
        }

        private SortedSet<ReferenceKey> findReferences(BHiveExecution hive) {
            if (hive == null) {
                return null;
            }
            return this.findNestedReferences(hive, this.root, "", 0L);
        }

        private SortedSet<ReferenceKey> findNestedReferences(BHiveExecution hive, ObjectId tree, String path, long depth) {
            if (hive == null) {
                return null;
            }
            TreeSet<ReferenceKey> referenced = new TreeSet<ReferenceKey>();
            TreeView state = hive.execute(new ScanOperation().setTree(tree).setFollowReferences(false));
            state.visit(new TreeVisitor.Builder().onMissing(this::missing).onManifestRef(m3 -> {
                referenced.add(new ReferenceKey(path + m3.getPathString(), m3.getReferenced(), depth + (long)m3.getPath().size()));
                Manifest mf = hive.execute(new ManifestLoadOperation().setManifest(m3.getReferenced()));
                if (mf.references != null) {
                    for (ReferenceKey rk : mf.references) {
                        referenced.add(new ReferenceKey(path + m3.getPathString() + "/" + rk.getPath(), rk.key, depth + (long)m3.getPath().size() + rk.depth));
                    }
                } else {
                    referenced.addAll(this.findNestedReferences(hive, mf.getRoot(), path + m3.getPathString() + "/", depth + (long)m3.getPath().size()));
                }
            }).build());
            return referenced;
        }

        private void missing(MissingObjectView m3) {
            throw new IllegalStateException("Missing object: " + m3.getElementId() + " at " + m3.getPath());
        }

        public Key getKey() {
            return this.key;
        }
    }
}

