/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.model;

import io.bdeploy.bhive.model.Manifest;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;

public class SortManifestsByReferences
implements Comparator<Manifest> {
    @Override
    public int compare(Manifest o1, Manifest o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null || o2 == null) {
            return o1 == null ? -1 : 1;
        }
        if (o1.internalGetCachedReferences() == null && o2.internalGetCachedReferences() == null) {
            return o1.getKey().compareTo(o2.getKey());
        }
        if (o1.internalGetCachedReferences() == null) {
            return -1;
        }
        if (o2.internalGetCachedReferences() == null) {
            return 1;
        }
        Set o1r = o1.internalGetCachedReferences().stream().map(Manifest.ReferenceKey::getKey).collect(Collectors.toSet());
        Set o2r = o2.internalGetCachedReferences().stream().map(Manifest.ReferenceKey::getKey).collect(Collectors.toSet());
        if (o1r.isEmpty() && o2r.isEmpty()) {
            return o1.getKey().compareTo(o2.getKey());
        }
        if (o1r.isEmpty()) {
            return -1;
        }
        if (o2r.isEmpty()) {
            return 1;
        }
        if (o1r.contains(o2.getKey()) && o2r.contains(o1.getKey())) {
            throw new IllegalStateException("Circular manifest reference found: " + o1.getKey() + " <-> " + o2.getKey());
        }
        if (o1r.contains(o2.getKey())) {
            return -1;
        }
        if (o2r.contains(o1.getKey())) {
            return 1;
        }
        return o1.getKey().compareTo(o2.getKey());
    }
}

