/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.bdeploy.bhive.ManifestSpawnListener;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.LockableDatabase;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestDatabase
extends LockableDatabase
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ManifestDatabase.class);
    private final Path root;
    private final Path tmp;
    private final List<ManifestSpawnListener> listeners = new ArrayList<ManifestSpawnListener>();
    private ScheduledFuture<?> schedNotify;
    private final List<Manifest.Key> added = new ArrayList<Manifest.Key>();
    private static final ScheduledExecutorService NOTIFY_POOL = Executors.newScheduledThreadPool(2, new NamedDaemonThreadFactory("Manifest DB Notifier"));
    private final Cache<Manifest.Key, Manifest> manifestCache = CacheBuilder.newBuilder().maximumSize(2500L).build();
    private final Cache<Path, Set<Manifest.Key>> manifestListCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public ManifestDatabase(Path root) {
        super(root);
        this.root = root;
        this.tmp = root.resolve(".tmp");
        if (!PathHelper.exists(root)) {
            PathHelper.mkdirs(root);
        }
        if (!PathHelper.exists(this.tmp)) {
            PathHelper.mkdirs(this.tmp);
        }
    }

    @Override
    public void close() {
        if (this.schedNotify != null && !this.schedNotify.isDone()) {
            this.schedNotify.cancel(false);
        }
    }

    public void addSpawnListener(ManifestSpawnListener listener) {
        this.listeners.add(listener);
    }

    public void removeSpawnListener(ManifestSpawnListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleNotify(Manifest.Key key) {
        if (this.listeners.isEmpty()) {
            return;
        }
        List<Manifest.Key> list = this.added;
        synchronized (list) {
            if (log.isDebugEnabled()) {
                log.debug("Adding {} to notify queue", (Object)key);
            }
            this.added.add(key);
        }
        if (this.schedNotify != null && !this.schedNotify.isDone()) {
            if (log.isDebugEnabled()) {
                log.debug("Cancel existing scheduled notify");
            }
            this.schedNotify.cancel(false);
        }
        this.schedNotify = NOTIFY_POOL.schedule(() -> {
            ArrayList<Manifest.Key> copy;
            List<Manifest.Key> list = this.added;
            synchronized (list) {
                if (log.isDebugEnabled()) {
                    log.debug("Notify {} listeners: {}", (Object)this.listeners.size(), (Object)this.added);
                }
                copy = new ArrayList<Manifest.Key>(this.added);
                this.added.clear();
            }
            for (ManifestSpawnListener listener : this.listeners) {
                try {
                    listener.spawn(copy);
                }
                catch (Exception e) {
                    log.warn("Exception in manifest listener", e);
                }
            }
        }, 100L, TimeUnit.MILLISECONDS);
    }

    private Path getPathForKey(Manifest.Key key) {
        return this.root.resolve(key.getName()).resolve(key.getTag());
    }

    public boolean hasManifest(Manifest.Key key) {
        return PathHelper.exists(this.getPathForKey(key));
    }

    public void addManifest(Manifest manifest) {
        this.locked(() -> {
            if (this.hasManifest(manifest.getKey())) {
                throw new IllegalArgumentException("Manifest " + manifest.getKey() + " already present.");
            }
            Path pathForKey = this.getPathForKey(manifest.getKey());
            PathHelper.mkdirs(pathForKey.getParent());
            if (pathForKey.getClass().getSimpleName().contains("Zip")) {
                Files.write(pathForKey, StorageHelper.toRawBytes(manifest), StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            } else {
                Path tmpFile = Files.createTempFile(this.tmp, "mf-", ".tmp", new FileAttribute[0]);
                try {
                    Files.write(tmpFile, StorageHelper.toRawBytes(manifest), StandardOpenOption.SYNC, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    Files.move(tmpFile, pathForKey, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Throwable t) {
                    PathHelper.deleteRecursive(tmpFile);
                    throw t;
                }
            }
            this.manifestCache.put(manifest.getKey(), manifest);
            this.manifestListCache.invalidateAll();
            this.scheduleNotify(manifest.getKey());
        });
    }

    public void removeManifest(Manifest.Key key) {
        this.locked(() -> {
            Files.deleteIfExists(this.getPathForKey(key));
            this.manifestCache.invalidate(key);
            this.manifestListCache.invalidateAll();
        });
    }

    public Set<Manifest.Key> getAllManifests() {
        return this.collectManifestsCached(this.root);
    }

    private Set<Manifest.Key> collectManifestsCached(Path r) {
        try {
            return this.manifestListCache.get(r, () -> this.collectManifests(r));
        }
        catch (ExecutionException e) {
            log.warn("Cannot fetch manifest list cache", e);
            return this.collectManifests(r);
        }
    }

    private Set<Manifest.Key> collectManifests(Path scanRoot) {
        TreeSet<Manifest.Key> result = new TreeSet<Manifest.Key>();
        long xctpCount = 0L;
        while (true) {
            TreeSet<Manifest.Key> treeSet;
            block13: {
                if (!Files.isDirectory(scanRoot, new LinkOption[0])) {
                    return result;
                }
                Stream<Path> walk = Files.walk(scanRoot, new FileVisitOption[0]);
                try {
                    walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                        if (f.startsWith(this.tmp)) {
                            return;
                        }
                        Path rel = this.root.relativize((Path)f);
                        if (rel.getParent() == null) {
                            return;
                        }
                        String manifestName = rel.getParent().toString().replace('\\', '/');
                        String manifestTag = rel.getFileName().toString();
                        result.add(new Manifest.Key(manifestName, manifestTag));
                    });
                    treeSet = result;
                    if (walk == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (walk != null) {
                                try {
                                    walk.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (UncheckedIOException | NoSuchFileException e) {
                            if (e instanceof NoSuchFileException || e.getCause() instanceof NoSuchFileException || xctpCount++ > 10L) continue;
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Error reading manifest database", e);
                    }
                }
                walk.close();
            }
            return treeSet;
            break;
        }
    }

    public Set<Manifest.Key> getAllForName(String name) {
        if (name.contains(":")) {
            TreeSet<Manifest.Key> result = new TreeSet<Manifest.Key>();
            Manifest.Key key = Manifest.Key.parse(name);
            if (this.hasManifest(key)) {
                result.add(key);
            }
            return result;
        }
        Path namedRoot = this.root.resolve(name);
        return this.collectManifestsCached(namedRoot);
    }

    public Manifest getManifest(Manifest.Key key) {
        try {
            return this.manifestCache.get(key, () -> {
                Manifest manifest;
                block9: {
                    if (!this.hasManifest(key)) {
                        throw new IllegalArgumentException("Don't have manifest " + key);
                    }
                    InputStream is = Files.newInputStream(this.getPathForKey(key), new OpenOption[0]);
                    try {
                        manifest = StorageHelper.fromStream(is, Manifest.class);
                        if (is == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Cannot read manifest " + key, e);
                        }
                    }
                    is.close();
                }
                return manifest;
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new IllegalStateException("Cannot load manifest into cache: " + key, e);
        }
    }

    public void invalidateCaches() {
        this.manifestCache.invalidateAll();
        this.manifestListCache.invalidateAll();
    }
}

