/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.objects.ObjectWriter;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class MarkerDatabase
extends ObjectDatabase {
    public MarkerDatabase(Path root, ActivityReporter reporter) {
        super(root, root.resolve("tmp"), reporter, null);
    }

    public void addMarker(ObjectId id) {
        if (this.hasObject(id)) {
            return;
        }
        this.locked(() -> {
            if (this.hasObject(id)) {
                return;
            }
            Path markerFile = this.getObjectFile(id);
            PathHelper.mkdirs(markerFile.getParent());
            try {
                Files.createFile(markerFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot add marker for " + id, e);
            }
        });
    }

    @Override
    public InputStream getStream(ObjectId id) throws IOException {
        throw new UnsupportedOperationException("Marker-only Database");
    }

    @Override
    protected ObjectId internalAddObject(ObjectWriter writer) throws IOException {
        throw new UnsupportedOperationException("Marker-only Database");
    }

    @Override
    public void removeObject(ObjectId id) {
        throw new UnsupportedOperationException("Marker-only Database");
    }
}

