/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.LockableDatabase;
import io.bdeploy.bhive.objects.ObjectWriter;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedSet;

public class ObjectDatabase
extends LockableDatabase {
    static final long MAX_BUFFER_SIZE = 0xA00000L;
    private final Path root;
    private final Path tmp;
    private final ActivityReporter reporter;
    private final BHiveTransactions transactions;

    public ObjectDatabase(Path root, Path tmp, ActivityReporter reporter, BHiveTransactions transactions) {
        super(root);
        this.root = root;
        this.tmp = tmp;
        this.reporter = reporter;
        this.transactions = transactions;
        if (!PathHelper.exists(root)) {
            PathHelper.mkdirs(root);
        }
        if (!PathHelper.exists(tmp)) {
            PathHelper.mkdirs(tmp);
        }
    }

    public InputStream getStream(ObjectId id) throws IOException {
        if (!this.hasObject(id)) {
            throw new IllegalStateException("Missing object: " + id);
        }
        return Files.newInputStream(this.getObjectFile(id), new OpenOption[0]);
    }

    public boolean hasObject(ObjectId id) {
        return PathHelper.exists(this.getObjectFile(id));
    }

    public ObjectId addObject(Path file) throws IOException {
        long size = Files.size(file);
        if (size >= 0xA00000L) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                ObjectId objectId = this.addObject(is);
                return objectId;
            }
        }
        byte[] bytes = Files.readAllBytes(file);
        return this.addObject(bytes);
    }

    public ObjectId addObject(byte[] bytes) throws IOException {
        return this.internalAddObject(p -> {
            Files.write(p, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return ObjectId.create(bytes, 0, bytes.length);
        });
    }

    public ObjectId addObject(InputStream stream) throws IOException {
        return this.internalAddObject(p -> ObjectId.createByCopy(stream, p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectId internalAddObject(ObjectWriter writer) throws IOException {
        Path tmpFile = Files.createTempFile(this.tmp, "obj", ".tmp", new FileAttribute[0]);
        try {
            ObjectId id = writer.write(tmpFile);
            Path target = this.getObjectFile(id);
            if (this.transactions != null) {
                this.transactions.touchObject(id);
            }
            this.locked(() -> {
                if (this.hasObject(id)) {
                    return;
                }
                PathHelper.mkdirs(target.getParent());
                Files.move(tmpFile, target, new CopyOption[0]);
            });
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    public boolean checkObject(ObjectId id) throws IOException {
        try (InputStream is = this.getStream(id);){
            ObjectId newId = ObjectId.createFromStreamNoCopy(is);
            boolean bl = newId.equals(id);
            return bl;
        }
    }

    public void removeObject(ObjectId id) {
        Path file = this.getObjectFile(id);
        this.locked(() -> {
            if (!this.hasObject(id)) {
                return;
            }
            Files.delete(file);
        });
    }

    public Path getObjectFile(ObjectId id) {
        String rawId = id.getId();
        String l1 = rawId.substring(0, 2);
        String l2 = rawId.substring(2, 4);
        return this.root.resolve(this.root.getFileSystem().getPath(l1, l2, rawId));
    }

    public long getObjectSize(ObjectId id) throws IOException {
        return Files.size(this.getObjectFile(id));
    }

    /*
     * Exception decompiling
     */
    public SortedSet<ObjectId> getAllObjects() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$getAllObjects$5(ActivityReporter.Activity scan, ObjectId e) {
        scan.workAndCancelIfRequested(1L);
    }

    private static /* synthetic */ boolean lambda$getAllObjects$4(Path x$0) {
        return Files.isRegularFile(x$0, new LinkOption[0]);
    }
}

