/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects.view;

import io.bdeploy.bhive.model.ObjectId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class ElementView
implements Comparable<ElementView> {
    private final ObjectId id;
    private final List<String> path;

    protected ElementView(ObjectId id, Collection<String> path) {
        this.id = id;
        this.path = new ArrayList<String>(path);
    }

    public ObjectId getElementId() {
        return this.id;
    }

    public List<String> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    public String getPathString() {
        return String.join((CharSequence)"/", this.path);
    }

    public String getName() {
        if (this.path.isEmpty()) {
            return "ROOT";
        }
        return this.path.get(this.path.size() - 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[path:" + this.getPathString() + ", id:" + this.id + "]";
    }

    @Override
    public int compareTo(ElementView o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementView other = (ElementView)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

