/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects.view.scanner;

import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.objects.view.BlobView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeElementDiff;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;

public class TreeDiff {
    private final TreeView left;
    private final TreeView right;

    public TreeDiff(TreeView left, TreeView right) {
        this.left = left;
        this.right = right;
    }

    public List<TreeElementDiff> diff() {
        FlattenedTree flatLeft = new FlattenedTree(this.left);
        FlattenedTree flatRight = new FlattenedTree(this.right);
        Map<String, FlattenedTreeEntry> itemsLeft = flatLeft.flatten();
        Map<String, FlattenedTreeEntry> itemsRight = flatRight.flatten();
        TreeSet<String> keysOnlyLeft = new TreeSet<String>(itemsLeft.keySet());
        TreeSet<String> keysOnlyRight = new TreeSet<String>(itemsRight.keySet());
        keysOnlyLeft.removeAll(itemsRight.keySet());
        keysOnlyRight.removeAll(itemsLeft.keySet());
        ArrayList<TreeElementDiff> diffs = new ArrayList<TreeElementDiff>();
        keysOnlyLeft.forEach(k -> diffs.add(TreeElementDiff.onlyLeft(((FlattenedTreeEntry)itemsLeft.get((Object)k)).element, ((FlattenedTreeEntry)itemsLeft.get((Object)k)).type)));
        keysOnlyRight.forEach(k -> diffs.add(TreeElementDiff.onlyRight(((FlattenedTreeEntry)itemsRight.get((Object)k)).element, ((FlattenedTreeEntry)itemsRight.get((Object)k)).type)));
        TreeSet<String> keysOnBoth = new TreeSet<String>(itemsLeft.keySet());
        keysOnBoth.retainAll(itemsRight.keySet());
        for (String k2 : keysOnBoth) {
            FlattenedTreeEntry entryLeft = itemsLeft.get(k2);
            FlattenedTreeEntry entryRight = itemsRight.get(k2);
            ObjectId leftMfRef = null;
            ObjectId rightMfRef = null;
            if (entryLeft.element instanceof ManifestRefView) {
                leftMfRef = ((ManifestRefView)entryLeft.element).getReferenceId();
            }
            if (entryRight.element instanceof ManifestRefView) {
                rightMfRef = ((ManifestRefView)entryRight.element).getReferenceId();
            }
            if (Objects.equals(leftMfRef, rightMfRef) && entryLeft.element.getElementId().equals(entryRight.element.getElementId())) continue;
            diffs.add(TreeElementDiff.content(entryLeft.element, entryRight.element, entryLeft.type, entryRight.type));
        }
        return diffs;
    }

    private static class FlattenedTree {
        private final Map<String, FlattenedTreeEntry> result = new TreeMap<String, FlattenedTreeEntry>();
        private final TreeView snapshot;

        public FlattenedTree(TreeView snapshot) {
            this.snapshot = snapshot;
        }

        synchronized Map<String, FlattenedTreeEntry> flatten() {
            if (!this.result.isEmpty()) {
                return this.result;
            }
            this.snapshot.visit(new TreeVisitor.Builder().onMissing(this::invalid).onSkipped(this::invalid).onBlob(this::blob).onManifestRef(this::manifest).onTree(this::tree).build());
            return this.result;
        }

        private void add(ElementView s2, Tree.EntryType t) {
            this.result.put(s2.getPathString(), new FlattenedTreeEntry(s2, t));
        }

        private void blob(BlobView b) {
            this.add(b, Tree.EntryType.BLOB);
        }

        private void manifest(ManifestRefView m3) {
            this.add(m3, Tree.EntryType.MANIFEST);
        }

        private Boolean tree(TreeView t) {
            if (t instanceof ManifestRefView) {
                return true;
            }
            this.add(t, Tree.EntryType.TREE);
            return true;
        }

        private void invalid(ElementView sn) {
            throw new IllegalStateException("Diff on damaged trees not supported, missing " + sn.getPath() + " [" + sn.getElementId() + "]");
        }
    }

    private static class FlattenedTreeEntry {
        ElementView element;
        Tree.EntryType type;

        FlattenedTreeEntry(ElementView element, Tree.EntryType type) {
            this.element = element;
            this.type = type;
        }
    }
}

