/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects.view.scanner;

import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.objects.view.ElementView;

public class TreeElementDiff {
    private final ElementView left;
    private final ElementView right;
    private final DifferenceType type;
    private final Tree.EntryType leftType;
    private final Tree.EntryType rightType;

    private TreeElementDiff(ElementView left, ElementView right, DifferenceType type, Tree.EntryType leftType, Tree.EntryType rightType) {
        this.left = left;
        this.right = right;
        this.type = type;
        this.leftType = leftType;
        this.rightType = rightType;
    }

    public static TreeElementDiff onlyLeft(ElementView element, Tree.EntryType type) {
        return new TreeElementDiff(element, null, DifferenceType.ONLY_LEFT, type, null);
    }

    public static TreeElementDiff onlyRight(ElementView element, Tree.EntryType type) {
        return new TreeElementDiff(null, element, DifferenceType.ONLY_RIGHT, null, type);
    }

    public static TreeElementDiff content(ElementView left, ElementView right, Tree.EntryType leftType, Tree.EntryType rightType) {
        return new TreeElementDiff(left, right, DifferenceType.CONTENT_DIFF, leftType, rightType);
    }

    public ElementView getLeft() {
        return this.left;
    }

    public Tree.EntryType getLeftType() {
        return this.leftType;
    }

    public ElementView getRight() {
        return this.right;
    }

    public Tree.EntryType getRightType() {
        return this.rightType;
    }

    public DifferenceType getType() {
        return this.type;
    }

    public String toString() {
        switch (this.type) {
            case CONTENT_DIFF: {
                return this.type.name() + ": " + this.left.getPath() + ": " + this.format(this.left, this.leftType) + " <--> " + this.format(this.right, this.rightType);
            }
            case ONLY_LEFT: {
                return this.type.name() + ": " + this.left.getPath() + ": " + this.format(this.left, this.leftType);
            }
            case ONLY_RIGHT: {
                return this.type.name() + ": " + this.right.getPath() + ": " + this.format(this.right, this.rightType);
            }
        }
        return "<Unknown Difference>";
    }

    private String format(ElementView s2, Tree.EntryType t) {
        return "[" + t.name() + "]" + s2.getElementId();
    }

    public static enum DifferenceType {
        ONLY_LEFT,
        ONLY_RIGHT,
        CONTENT_DIFF;

    }
}

