/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.op.LockDirectoryOperation;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.common.util.RuntimeAssert;
import io.bdeploy.common.util.Threads;
import java.nio.file.Path;

public class AwaitDirectoryLockOperation
extends BHive.Operation<Void> {
    private Path directory;

    @Override
    public Void call() throws Exception {
        RuntimeAssert.assertNotNull(this.directory, "No directory to await.");
        Path lockFile = this.directory.resolve(".lock");
        for (int i = 0; i < 100000; ++i) {
            if (!PathHelper.exists(lockFile) || !LockDirectoryOperation.isLockFileValid(lockFile, this.getLockContentValidator())) {
                return null;
            }
            if (!Threads.sleep(10L)) break;
        }
        throw new IllegalStateException("Retries exceeded or interrupted while waiting that lock " + lockFile + " is released. Please check manually if another process is still running and delete the lock file manually.");
    }

    public AwaitDirectoryLockOperation setDirectory(Path directory) {
        this.directory = directory;
        return this;
    }
}

