/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveExecution;
import io.bdeploy.bhive.BHiveTransactions;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.ManifestDatabase;
import io.bdeploy.bhive.op.InsertExistingObjectsOperation;
import io.bdeploy.bhive.op.InsertManifestOperation;
import io.bdeploy.bhive.op.ManifestConsistencyCheckOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestRefScanOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CopyOperation
extends BHive.Operation<TransferStatistics> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> objects = new TreeSet<ObjectId>();
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    @AuditParameterExtractor.NoAudit
    private BHiveExecution destinationHive;
    private boolean partialAllowed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatistics call() throws Exception {
        TransferStatistics result = new TransferStatistics();
        Instant start = Instant.now();
        RuntimeAssert.assertNotNull(this.destinationHive, "Destination Hive not set");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Copying Objects");
             BHiveTransactions.Transaction t = this.destinationHive.getTransactions().begin();){
            if (this.objects.isEmpty() && this.manifests.isEmpty()) {
                this.execute(new ManifestListOperation()).forEach(this.manifests::add);
                this.execute(new ObjectListOperation().addManifest(this.manifests)).forEach(this.objects::add);
            }
            result.sumManifests = this.manifests.size();
            result.sumMissingObjects = this.objects.size();
            TreeSet additional = new TreeSet();
            this.manifests.forEach(m3 -> additional.addAll(this.execute(new ManifestRefScanOperation().setAllowMissingObjects(true).setManifest((Manifest.Key)m3)).values()));
            this.manifests.addAll(additional);
            if (!this.objects.isEmpty()) {
                InsertExistingObjectsOperation destinationInsert = new InsertExistingObjectsOperation().setSourceObjectManager(this.getObjectManager());
                this.objects.forEach(destinationInsert::addObject);
                this.destinationHive.execute(destinationInsert);
            }
            if (!this.manifests.isEmpty()) {
                ManifestDatabase mdb = this.getManifestDatabase();
                List<Manifest> loaded = this.manifests.stream().map(mdb::getManifest).collect(Collectors.toList());
                InsertManifestOperation destinationManifestInsert = new InsertManifestOperation();
                loaded.forEach(destinationManifestInsert::addManifest);
                this.destinationHive.execute(destinationManifestInsert);
                if (!this.partialAllowed) {
                    ManifestConsistencyCheckOperation destinationCheck = new ManifestConsistencyCheckOperation().setDryRun(false);
                    this.manifests.forEach(destinationCheck::addRoot);
                    this.destinationHive.execute(destinationCheck);
                }
            }
        }
        finally {
            result.duration = Duration.between(start, Instant.now()).toMillis();
        }
        return result;
    }

    public CopyOperation addObject(ObjectId object) {
        this.objects.add(object);
        return this;
    }

    public CopyOperation addObject(Collection<ObjectId> objectIds) {
        this.objects.addAll(objectIds);
        return this;
    }

    public CopyOperation addManifest(Collection<Manifest.Key> keys) {
        this.manifests.addAll(keys);
        return this;
    }

    public CopyOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public CopyOperation setPartialAllowed(boolean allowed) {
        this.partialAllowed = allowed;
        return this;
    }

    public CopyOperation setDestinationHive(BHiveExecution hive) {
        this.destinationHive = hive;
        return this;
    }
}

