/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.ReferenceHandler;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Path;

@ReadOnlyOperation
public class ExportTreeOperation
extends BHive.Operation<Void> {
    private Path target;
    private ObjectId treeId;
    private ReferenceHandler refHandler;

    @Override
    public Void call() throws Exception {
        RuntimeAssert.assertNotNull(this.target, "Target path not set");
        RuntimeAssert.assertNotNull(this.treeId, "Source tree not set");
        this.getObjectManager().exportTree(this.treeId, this.target, this.refHandler);
        return null;
    }

    public ExportTreeOperation setTargetPath(Path target) {
        this.target = target;
        return this;
    }

    public ExportTreeOperation setSourceTree(ObjectId treeId) {
        this.treeId = treeId;
        return this;
    }

    public ExportTreeOperation setReferenceHandler(ReferenceHandler handler) {
        this.refHandler = handler;
        return this;
    }
}

