/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ImportFileOperation
extends BHive.TransactedOperation<ObjectId> {
    private Path file;

    @Override
    public ObjectId callTransacted() throws Exception {
        RuntimeAssert.assertNotNull(this.file, "File to import not set");
        return this.getObjectManager().db(x -> x.addObject(this.file));
    }

    public ImportFileOperation setFile(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + file);
        }
        this.file = file;
        return this;
    }
}

