/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Path;

public class ImportTreeOperation
extends BHive.TransactedOperation<ObjectId> {
    private Path toImport;
    private boolean skipEmpty = false;

    @Override
    public ObjectId callTransacted() throws Exception {
        RuntimeAssert.assertNotNull(this.toImport, "Source path not set");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Importing", -1L);){
            ObjectId objectId = this.getObjectManager().importTree(this.toImport, this.skipEmpty);
            return objectId;
        }
    }

    public ImportTreeOperation setSourcePath(Path toImport) {
        this.toImport = toImport;
        return this;
    }

    public ImportTreeOperation setSkipEmpty(boolean skip) {
        this.skipEmpty = skip;
        return this;
    }
}

