/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.ObjectManager;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.FutureHelper;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;

public class InsertExistingObjectsOperation
extends BHive.TransactedOperation<Long> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> objects = new TreeSet<ObjectId>();
    private ObjectManager sourceMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long callTransacted() throws Exception {
        RuntimeAssert.assertFalse(this.objects.isEmpty(), "Nothing to insert");
        RuntimeAssert.assertNotNull(this.sourceMgr, "No source object manager");
        ActivityReporter.Activity inserting = this.getActivityReporter().start("Inserting Objects", this.objects.size());
        try {
            ArrayList inserts = new ArrayList();
            for (ObjectId obj : this.objects) {
                if (Boolean.TRUE.equals(this.getObjectManager().db(x -> x.hasObject(obj)))) continue;
                inserts.add(this.submitFileOperation(() -> {
                    try (InputStream is = this.sourceMgr.db(x -> x.getStream(obj));){
                        ObjectId newId = this.getObjectManager().db(x -> x.addObject(is));
                        RuntimeAssert.assertTrue(newId.equals(obj), "Copy produced different ID - something is broken!");
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("cannot insert object " + obj, e);
                    }
                    inserting.workAndCancelIfRequested(1L);
                }));
            }
            FutureHelper.awaitAll(inserts);
        }
        finally {
            inserting.done();
        }
        return this.objects.size();
    }

    public InsertExistingObjectsOperation addObject(ObjectId object) {
        this.objects.add(object);
        return this;
    }

    public InsertExistingObjectsOperation setSourceObjectManager(ObjectManager db) {
        this.sourceMgr = db;
        return this;
    }
}

