/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.common.util.RuntimeAssert;
import io.bdeploy.common.util.StringHelper;
import io.bdeploy.common.util.Threads;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockDirectoryOperation
extends BHive.Operation<Void> {
    private static final Logger log = LoggerFactory.getLogger(LockDirectoryOperation.class);
    static final String LOCK_FILE = ".lock";
    private Path directory;

    @Override
    public Void call() throws Exception {
        RuntimeAssert.assertNotNull(this.directory, "No directory to lock.");
        Path lockFile = this.directory.resolve(LOCK_FILE);
        String content = "";
        if (this.getLockContentSupplier() != null) {
            content = this.getLockContentSupplier().get();
        }
        boolean infoWritten = false;
        for (int i = 0; i < 100000; ++i) {
            try {
                Files.write(lockFile, Collections.singletonList(content), StandardOpenOption.CREATE_NEW, StandardOpenOption.SYNC).toFile().deleteOnExit();
                return null;
            }
            catch (IOException e) {
                if (!LockDirectoryOperation.isLockFileValid(lockFile, this.getLockContentValidator())) continue;
                if (!infoWritten) {
                    log.info("Waiting for {}", (Object)this.directory);
                    infoWritten = true;
                }
                if (Threads.sleep(10L)) continue;
                break;
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot lock root", e);
            }
        }
        throw new IllegalStateException("Retries exceeded or interrupted while waiting to lock " + lockFile + ". Please check manually if another process is still running and delete the lock file manually.");
    }

    public LockDirectoryOperation setDirectory(Path directory) {
        this.directory = directory;
        return this;
    }

    static boolean isLockFileValid(Path lockFile, Predicate<String> lockContentValidator) {
        if (lockContentValidator == null) {
            return true;
        }
        try {
            List<String> lines = Files.readAllLines(lockFile);
            if (!(lines.isEmpty() || StringHelper.isNullOrEmpty(lines.get(0)) || lockContentValidator.test(lines.get(0)))) {
                log.warn("Stale lock file detected, forcefully resolving...");
                Files.delete(lockFile);
                return false;
            }
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException fne) {
            return false;
        }
        catch (IOException ve) {
            log.warn("Cannot validate lock file, assuming it is valid: {}: {}", (Object)lockFile, (Object)ve.toString());
            return true;
        }
    }
}

