/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ManifestConsistencyCheckOperation
extends BHive.Operation<Set<ElementView>> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    private boolean dryRun = true;

    @Override
    public Set<ElementView> call() throws Exception {
        RuntimeAssert.assertFalse(this.manifests.isEmpty(), "Nothing to check");
        TreeSet<ElementView> dmg = new TreeSet<ElementView>();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Checking Manifests", this.manifests.size());){
            for (Manifest.Key key : this.manifests) {
                ArrayList broken = new ArrayList();
                if (!Boolean.TRUE.equals(this.execute(new ManifestExistsOperation().setManifest(key)))) continue;
                TreeView state = this.execute(new ScanOperation().setManifest(key));
                state.visit(new TreeVisitor.Builder().onMissing(broken::add).build());
                if (!broken.isEmpty() && !this.dryRun) {
                    this.execute(new ManifestDeleteOperation().setToDelete(key));
                }
                dmg.addAll(broken);
                activity.workAndCancelIfRequested(1L);
            }
        }
        return dmg;
    }

    public ManifestConsistencyCheckOperation addRoot(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public ManifestConsistencyCheckOperation setDryRun(boolean dry) {
        this.dryRun = dry;
        return this;
    }
}

