/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.PruneOperation;
import io.bdeploy.common.ActivityReporter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestDeleteOldByIdOperation
extends BHive.Operation<Void> {
    private static final Logger log = LoggerFactory.getLogger(ManifestDeleteOldByIdOperation.class);
    private String manifestName;
    private int amountToKeep = 10;
    private boolean runGc;
    private Consumer<Manifest.Key> preDelete;

    @Override
    public Void call() throws Exception {
        Set<Manifest.Key> execute = this.execute(new ManifestListOperation().setManifestName(this.manifestName));
        SortedMap mfsByKey = execute.stream().collect(Collectors.groupingBy(k -> Long.valueOf(k.getTag()), TreeMap::new, Collectors.toList()));
        if (mfsByKey.size() <= this.amountToKeep) {
            return null;
        }
        long i = mfsByKey.size() - this.amountToKeep;
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Deleting", i);){
            for (Map.Entry entry : mfsByKey.entrySet()) {
                if (((List)entry.getValue()).size() != 1) {
                    log.warn("Expected exactly one manifest match per tag: {}, {}", entry.getKey(), entry.getValue());
                    continue;
                }
                Manifest.Key k2 = (Manifest.Key)((List)entry.getValue()).get(0);
                if (this.preDelete != null) {
                    this.preDelete.accept(k2);
                }
                this.execute(new ManifestDeleteOperation().setToDelete(k2));
                if (--i == 0L) break;
                activity.workAndCancelIfRequested(1L);
            }
            if (this.runGc) {
                this.execute(new PruneOperation());
            }
        }
        return null;
    }

    public ManifestDeleteOldByIdOperation setToDelete(String toDelete) {
        this.manifestName = toDelete;
        return this;
    }

    public ManifestDeleteOldByIdOperation setAmountToKeep(int amount) {
        this.amountToKeep = amount;
        return this;
    }

    public ManifestDeleteOldByIdOperation setRunGarbageCollector(boolean gc) {
        this.runGc = gc;
        return this;
    }

    public ManifestDeleteOldByIdOperation setPreDeleteHook(Consumer<Manifest.Key> hook) {
        this.preDelete = hook;
        return this;
    }
}

