/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.InputStream;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

@ReadOnlyOperation
public class ManifestRefLoadOperation
extends BHive.Operation<SortedMap<ObjectId, Manifest.Key>> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<ObjectId> ids = new TreeSet<ObjectId>();

    @Override
    public SortedMap<ObjectId, Manifest.Key> call() throws Exception {
        RuntimeAssert.assertFalse(this.ids.isEmpty(), "Nothing to load");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Loading Relations", -1L);){
            TreeMap<ObjectId, Manifest.Key> refs = new TreeMap<ObjectId, Manifest.Key>();
            for (ObjectId id : this.ids) {
                InputStream is = this.getObjectManager().db(x -> x.getStream(id));
                try {
                    refs.put(id, StorageHelper.fromStream(is, Manifest.Key.class));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            TreeMap<ObjectId, Manifest.Key> treeMap = refs;
            return treeMap;
        }
    }

    public ManifestRefLoadOperation addManifestRef(ObjectId manifest) {
        this.ids.add(manifest);
        return this;
    }
}

