/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.MissingObjectView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ObjectExistsOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.SortedMap;
import java.util.TreeMap;

@ReadOnlyOperation
public class ManifestRefScanOperation
extends BHive.Operation<SortedMap<String, Manifest.Key>> {
    private Manifest.Key manifest;
    private boolean allowMissing = false;
    private int maxDepth = Integer.MAX_VALUE;

    @Override
    public SortedMap<String, Manifest.Key> call() throws Exception {
        RuntimeAssert.assertNotNull(this.manifest, "Nothing to scan");
        Manifest mf = this.execute(new ManifestLoadOperation().setManifest(this.manifest));
        SortedMap<String, Manifest.Key> cachedReferences = mf.getCachedReferences(this, this.maxDepth, this.allowMissing);
        if (cachedReferences != null) {
            return cachedReferences;
        }
        TreeMap<String, Manifest.Key> referenced = new TreeMap<String, Manifest.Key>();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Finding Relations", -1L);){
            ObjectId root = mf.getRoot();
            if (this.allowMissing && this.execute(new ObjectExistsOperation().addObject(root)).isMissing(root)) {
                TreeMap<String, Manifest.Key> treeMap = referenced;
                return treeMap;
            }
            TreeView state = this.execute(new ScanOperation().setManifest(this.manifest).setMaxDepth(this.maxDepth));
            state.visit(new TreeVisitor.Builder().onMissing(this::missing).onManifestRef(m3 -> referenced.put(m3.getPathString(), m3.getReferenced())).build());
            TreeMap<String, Manifest.Key> treeMap = referenced;
            return treeMap;
        }
    }

    private void missing(MissingObjectView m3) {
        if (!this.allowMissing) {
            throw new IllegalStateException("Missing object: " + m3.getElementId() + " at " + m3.getPath());
        }
    }

    public ManifestRefScanOperation setManifest(Manifest.Key manifest) {
        this.manifest = manifest;
        return this;
    }

    public ManifestRefScanOperation setAllowMissingObjects(boolean allow) {
        this.allowMissing = allow;
        return this;
    }

    public ManifestRefScanOperation setMaxDepth(int max) {
        this.maxDepth = max;
        return this;
    }
}

