/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.common.ActivityReporter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

@ReadOnlyOperation
public class ObjectExistsOperation
extends BHive.Operation<Result> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final Set<ObjectId> objects = new LinkedHashSet<ObjectId>();

    @Override
    public Result call() throws Exception {
        Result result = new Result();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Looking up Objects", this.objects.size());){
            for (ObjectId o : this.objects) {
                if (Boolean.TRUE.equals(this.getObjectManager().db(x -> x.hasObject(o)))) {
                    result.existing.add(o);
                } else {
                    result.missing.add(o);
                }
                activity.worked(1L);
            }
        }
        return result;
    }

    public ObjectExistsOperation addObject(ObjectId obj) {
        this.objects.add(obj);
        return this;
    }

    public ObjectExistsOperation addAll(Collection<ObjectId> objs) {
        this.objects.addAll(objs);
        return this;
    }

    public static class Result {
        public final Set<ObjectId> existing = new LinkedHashSet<ObjectId>();
        public final Set<ObjectId> missing = new LinkedHashSet<ObjectId>();

        public boolean isExisting(ObjectId obj) {
            return this.existing.contains(obj);
        }

        public boolean isMissing(ObjectId obj) {
            return this.missing.contains(obj);
        }
    }
}

