/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.BlobView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ScanOperation;
import io.bdeploy.common.ActivityReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyOperation
public class ObjectListOperation
extends BHive.Operation<Set<ObjectId>> {
    private static final Logger log = LoggerFactory.getLogger(ObjectListOperation.class);
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final Set<Manifest.Key> manifests = new LinkedHashSet<Manifest.Key>();
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final Set<ObjectId> trees = new LinkedHashSet<ObjectId>();
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final Set<ObjectId> treeExcludes = new LinkedHashSet<ObjectId>();
    private boolean ignoreMissingManifest = false;

    @Override
    public Set<ObjectId> call() throws Exception {
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Finding Objects", -1L);){
            if (this.manifests.isEmpty() && this.trees.isEmpty()) {
                throw new IllegalStateException("At least one manifest or root tree must be set.");
            }
            for (Manifest.Key key : this.manifests) {
                try {
                    this.trees.add(this.execute(new ManifestLoadOperation().setManifest(key)).getRoot());
                }
                catch (Exception e) {
                    if (!Boolean.TRUE.equals(this.execute(new ManifestExistsOperation().setManifest(key)) != false && this.ignoreMissingManifest)) continue;
                    throw new IllegalStateException("Cannot read manifest even though it exists", e);
                }
            }
            LinkedHashMap object2Tree = new LinkedHashMap();
            for (ObjectId tree : this.trees) {
                TreeView treeView = this.execute(new ScanOperation().setTree(tree));
                if (treeView.getElementId() == null) {
                    log.warn("Skipping damaged tree: {}", (Object)tree);
                    continue;
                }
                treeView.visit(new TreeVisitor.Builder().onTree(t -> {
                    ObjectId treeId = t.getElementId();
                    if (object2Tree.containsKey(treeId) || this.treeExcludes.contains(treeId)) {
                        return false;
                    }
                    object2Tree.put(treeId, this.flattenTree((TreeView)t));
                    return true;
                }).build());
                activity.workAndCancelIfRequested(1L);
            }
            ArrayList arrayList = new ArrayList(object2Tree.values());
            Collections.reverse(arrayList);
            LinkedHashSet result = new LinkedHashSet();
            for (List flatTree : arrayList) {
                result.addAll(flatTree);
            }
            LinkedHashSet linkedHashSet = result;
            return linkedHashSet;
        }
    }

    private List<ObjectId> flattenTree(TreeView tv) {
        ArrayList<ObjectId> result = new ArrayList<ObjectId>();
        for (ElementView child : tv.getChildren().values()) {
            if (child instanceof BlobView) {
                result.add(child.getElementId());
                continue;
            }
            if (!(child instanceof ManifestRefView)) continue;
            ManifestRefView refView = (ManifestRefView)child;
            result.add(refView.getReferenceId());
        }
        result.add(tv.getElementId());
        return result;
    }

    public ObjectListOperation addManifest(Collection<Manifest.Key> manifests) {
        this.manifests.addAll(manifests);
        return this;
    }

    public ObjectListOperation addTree(Set<ObjectId> trees) {
        this.trees.addAll(trees);
        return this;
    }

    public ObjectListOperation excludeTree(Set<ObjectId> trees) {
        this.treeExcludes.addAll(trees);
        return this;
    }

    public ObjectListOperation addManifest(Manifest.Key manifest) {
        this.manifests.add(manifest);
        return this;
    }

    public ObjectListOperation addTree(ObjectId tree) {
        this.trees.add(tree);
        return this;
    }

    public ObjectListOperation excludeTree(ObjectId tree) {
        this.treeExcludes.add(tree);
        return this;
    }

    public ObjectListOperation ignoreMissingManifest(boolean ignore) {
        this.ignoreMissingManifest = ignore;
        return this;
    }
}

