/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import com.google.common.io.CountingInputStream;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.SortManifestsByReferences;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.op.ManifestConsistencyCheckOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.FixedLengthStream;
import io.bdeploy.common.util.ReportingInputStream;
import io.bdeploy.common.util.RuntimeAssert;
import io.bdeploy.common.util.StreamHelper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;

public class ObjectReadOperation
extends BHive.TransactedOperation<TransferStatistics> {
    @AuditParameterExtractor.NoAudit
    private InputStream input;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferStatistics callTransacted() throws Exception {
        TransferStatistics result = new TransferStatistics();
        Instant start = Instant.now();
        RuntimeAssert.assertNotNull(this.input);
        try (CountingInputStream countingIn = new CountingInputStream(this.input);
             BufferedInputStream buffIn = new BufferedInputStream(countingIn, 16384);
             GZIPInputStream zipIn = new GZIPInputStream((InputStream)buffIn, 8192);
             DataInputStream dataIn = new DataInputStream(zipIn);){
            long totalSize = dataIn.readLong();
            String baseActivity = "Receiving";
            ManifestConsistencyCheckOperation checkOp = new ManifestConsistencyCheckOperation();
            try (ActivityReporter.Activity activity = this.getActivityReporter().start(baseActivity, totalSize);
                 ReportingInputStream reportingIn = new ReportingInputStream(dataIn, totalSize, activity, baseActivity);){
                long size;
                TreeSet<ObjectId> objects = new TreeSet<ObjectId>();
                TreeSet<Manifest> manifests = new TreeSet<Manifest>();
                long counter = dataIn.readLong();
                int i = 0;
                while ((long)i < counter) {
                    size = dataIn.readLong();
                    Manifest mf2 = StorageHelper.fromStream(new FixedLengthStream(reportingIn, size), Manifest.class);
                    manifests.add(mf2);
                    checkOp.addRoot(mf2.getKey());
                    ++i;
                }
                counter = dataIn.readLong();
                i = 0;
                while ((long)i < counter) {
                    size = dataIn.readLong();
                    ObjectId insertedId = this.getObjectManager().db(db -> db.addObject(new FixedLengthStream(reportingIn, size)));
                    objects.add(insertedId);
                    ++i;
                }
                result.sumMissingObjects = counter;
                manifests.stream().sorted(new SortManifestsByReferences()).forEach(mf -> {
                    if (!this.getManifestDatabase().hasManifest(mf.getKey())) {
                        this.getManifestDatabase().addManifest((Manifest)mf);
                        ++result.sumManifests;
                    }
                });
                result.duration = Duration.between(start, Instant.now()).toMillis();
            }
            Set<ElementView> damaged = this.execute(checkOp.setDryRun(false));
            if (!damaged.isEmpty()) {
                throw new IllegalStateException("Failed to stream all required objects. Removed " + damaged.size() + " missing/damaged elements.");
            }
            result.transferSize = countingIn.getCount();
        }
        finally {
            if (result.duration == 0L) {
                result.duration = Duration.between(start, Instant.now()).toMillis();
            }
            StreamHelper.close(this.input);
        }
        return result;
    }

    public ObjectReadOperation stream(InputStream input) {
        this.input = input;
        return this;
    }
}

