/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.MarkerDatabase;
import io.bdeploy.bhive.op.LockDirectoryOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.op.ReleaseDirectoryLockOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.audit.AuditRecord;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PruneOperation
extends BHive.Operation<SortedMap<ObjectId, Long>> {
    private static final Logger log = LoggerFactory.getLogger(PruneOperation.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<ObjectId, Long> call() throws Exception {
        TreeMap<ObjectId, Long> result = new TreeMap<ObjectId, Long>();
        AtomicLong max = new AtomicLong(-1L);
        LongAdder current = new LongAdder();
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Prune (calculating)", max::get, current::sum);){
            this.execute(new LockDirectoryOperation().setDirectory(this.getMarkerRoot()));
            try {
                Set<Manifest.Key> manifests = this.execute(new ManifestListOperation());
                Set<Object> referenced = !manifests.isEmpty() ? this.execute(new ObjectListOperation().addManifest(manifests).ignoreMissingManifest(true)) : new TreeSet();
                SortedSet orig = this.getObjectManager().db(db -> {
                    try {
                        return db.getAllObjects();
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException("Interrupted", e1);
                    }
                });
                TreeSet all = new TreeSet(orig);
                all.removeAll(referenced);
                try (DirectoryStream<Path> markerDbs = Files.newDirectoryStream(this.getMarkerRoot());){
                    for (Path markerDb : markerDbs) {
                        if (!Files.isDirectory(markerDb, new LinkOption[0])) continue;
                        MarkerDatabase mdb = new MarkerDatabase(markerDb, this.getActivityReporter());
                        all.removeAll(mdb.getAllObjects());
                    }
                }
                ArrayList auditList = new ArrayList();
                activity.activity("Prune (cleaning)");
                max.set(all.size());
                for (ObjectId unreferenced : all) {
                    result.put(unreferenced, this.getObjectManager().db(x -> {
                        try {
                            long sz = x.getObjectSize(unreferenced);
                            x.removeObject(unreferenced);
                            if (auditList.size() < 50) {
                                auditList.add(unreferenced);
                            }
                            return sz;
                        }
                        catch (NoSuchFileException e) {
                            log.debug("To-be-removed object is no longer existing: {}", (Object)unreferenced);
                            return 0L;
                        }
                    }));
                    current.increment();
                }
                this.getAuditor().audit(AuditRecord.Builder.fromSystem().setSeverity(AuditRecord.Severity.NORMAL).setWhat(PruneOperation.class.getName()).setMessage("Removed " + result.size() + " Objects ").addParameter("removed", ((Object)auditList).toString()).build());
            }
            finally {
                this.execute(new ReleaseDirectoryLockOperation().setDirectory(this.getMarkerRoot()));
            }
            TreeMap<ObjectId, Long> treeMap = result;
            return treeMap;
        }
    }
}

